/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.model.LiNotasubcancelada;
import br.com.fiorilli.nfse_nacional.model.enums.StatusNfs;
import br.com.fiorilli.nfse_nacional.schema.v100.evento.TCEvento;
import br.com.fiorilli.nfse_nacional.schema.v100.evento.TE101101;
import br.com.fiorilli.nfse_nacional.schema.v100.evento.TE105102;
import br.com.fiorilli.nfse_nacional.schema.v100.evento.TE105104;
import br.com.fiorilli.nfse_nacional.schema.v100.evento.TE305101;
import br.com.fiorilli.nfse_nacional.services.NFSeRecebimentoService;
import br.com.fiorilli.nfse_nacional.services.data.LiNotafiscalService;
import br.com.fiorilli.nfse_nacional.utils.FiorilliUtils;
import br.com.fiorilli.nfse_nacional.utils.NsuObjectHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EventoRecebimentoService_v1_00 {
    private static final Logger log = LoggerFactory.getLogger(EventoRecebimentoService_v1_00.class);
    private final Map<TCEvento, Integer> cache = Collections.synchronizedMap(new HashMap());
    private final NFSeRecebimentoService nfSeRecebimentoService;
    private final LiNotafiscalService liNotafiscalService;

    public void processEvento(NsuObjectHolder<TCEvento> holder) {
        TCEvento tcEvento = (TCEvento)holder.getObject();
        String chaveNotaCancelada = tcEvento.getInfEvento().getPedRegEvento().getInfPedReg().getChNFSe();
        LiNotasubcancelada.LiNotasubcanceladaBuilder builder = EventoRecebimentoService_v1_00.defaultCancelamentoBuilder((TCEvento)tcEvento);
        TE101101 eventRef = tcEvento.getInfEvento().getPedRegEvento().getInfPedReg().getE101101();
        if (eventRef != null) {
            log.debug("Evento E101101 para evento {}", (Object)holder.getNsu());
            TE101101 evento = eventRef;
            LiNotasubcancelada cancelamento = builder.detalhemotivoNca("(" + evento.getCMotivo() + ") " + evento.getXMotivo()).build();
            this.nfSeRecebimentoService.saveCancelamento(chaveNotaCancelada, cancelamento, StatusNfs.CANCELADA);
        } else {
            eventRef = tcEvento.getInfEvento().getPedRegEvento().getInfPedReg().getE105102();
            if (eventRef != null) {
                log.debug("Evento E105102 para evento {}", (Object)holder.getNsu());
                TE105102 evento = (TE105102)eventRef;
                Optional optNotaSubstituta = this.liNotafiscalService.findCodNfsByChave(((TE105102)eventRef).getChSubstituta());
                if (optNotaSubstituta.isPresent()) {
                    LiNotasubcancelada cancelamento = builder.detalhemotivoNca("(" + evento.getCMotivo() + ") " + evento.getXMotivo()).codsubNfeNca((Integer)optNotaSubstituta.get()).build();
                    this.nfSeRecebimentoService.saveCancelamento(chaveNotaCancelada, cancelamento, StatusNfs.SUBSTITUIDA);
                } else {
                    this.cache.put(tcEvento, 1);
                }
            } else {
                eventRef = tcEvento.getInfEvento().getPedRegEvento().getInfPedReg().getE105104();
                if (eventRef != null) {
                    log.debug("Evento E105104 para evento {}", (Object)holder.getNsu());
                    TE105104 evento = (TE105104)eventRef;
                    LiNotasubcancelada cancelamento = builder.detalhemotivoNca("(" + evento.getCMotivo() + ") " + evento.getXMotivo()).build();
                    this.nfSeRecebimentoService.saveCancelamento(chaveNotaCancelada, cancelamento, StatusNfs.CANCELADA);
                } else {
                    eventRef = tcEvento.getInfEvento().getPedRegEvento().getInfPedReg().getE305101();
                    if (eventRef != null) {
                        log.debug("Evento E305101 para evento {}", (Object)holder.getNsu());
                        TE305101 evento = (TE305101)eventRef;
                        LiNotasubcancelada cancelamento = builder.detalhemotivoNca("(Cancelamento por Of\u00edcio) " + evento.getXDesc()).build();
                        this.nfSeRecebimentoService.saveCancelamento(chaveNotaCancelada, cancelamento, StatusNfs.CANCELADA);
                    }
                }
            }
        }
    }

    public void atualizarCache() {
        HashMap notWorked = new HashMap();
        this.cache.entrySet().stream().toList().forEach(entry -> {
            if ((Integer)entry.getValue() > 10) {
                this.cache.remove(entry.getKey());
            }
        });
        this.cache.forEach((tcEvento, counter) -> {
            TE105102 evento = tcEvento.getInfEvento().getPedRegEvento().getInfPedReg().getE105102();
            String chaveNotaSubstituida = tcEvento.getInfEvento().getPedRegEvento().getInfPedReg().getChNFSe();
            String chaveNotaSubstituta = evento.getChSubstituta();
            this.liNotafiscalService.findCodNfsByChave(chaveNotaSubstituta).ifPresentOrElse(codNfs -> {
                LiNotasubcancelada cancelamento = EventoRecebimentoService_v1_00.defaultCancelamentoBuilder((TCEvento)tcEvento).detalhemotivoNca("(" + evento.getCMotivo() + ") " + evento.getXMotivo()).codsubNfeNca(codNfs).build();
                this.nfSeRecebimentoService.saveCancelamento(chaveNotaSubstituida, cancelamento, StatusNfs.SUBSTITUIDA);
            }, () -> notWorked.put(tcEvento, counter + 1));
        });
        this.cache.clear();
        this.cache.putAll(notWorked);
    }

    private static LiNotasubcancelada.LiNotasubcanceladaBuilder defaultCancelamentoBuilder(TCEvento tcEvento) {
        return LiNotasubcancelada.builder().chaveEventoNfseNca(tcEvento.getInfEvento().getId()).datacancelaNca(FiorilliUtils.toDateTime((String)tcEvento.getInfEvento().getPedRegEvento().getInfPedReg().getDhEvento()).toLocalDate());
    }

    public EventoRecebimentoService_v1_00(NFSeRecebimentoService nfSeRecebimentoService, LiNotafiscalService liNotafiscalService) {
        this.nfSeRecebimentoService = nfSeRecebimentoService;
        this.liNotafiscalService = liNotafiscalService;
    }
}

