/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.schema.v101.evento.TCEvento;
import br.com.fiorilli.nfse_nacional.services.IntegradorCache;
import br.com.fiorilli.nfse_nacional.utils.NsuObjectHolder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IntegradorCache {
    private static final Logger log = LoggerFactory.getLogger(IntegradorCache.class);
    private final Path cachePath = Path.of("logs.cached", new String[0]);
    private final HashMap<String, LinkedList<Object>> caches = new HashMap();
    private boolean loaded = false;

    @PostConstruct
    public void init() {
        this.loadFromFile();
    }

    public boolean areCachesEmpty() {
        return this.getEventos().isEmpty();
    }

    public synchronized void addEvento(NsuObjectHolder<br.com.fiorilli.nfse_nacional.schema.v100.evento.TCEvento> evento) {
        this.getEventos().add(evento);
    }

    public synchronized void addEvento_v1_01(NsuObjectHolder<TCEvento> evento) {
        this.getEventos_v1_01().add(evento);
    }

    public synchronized LinkedList<NsuObjectHolder<br.com.fiorilli.nfse_nacional.schema.v100.evento.TCEvento>> getEventos() {
        return this.getCache("adn_eventos");
    }

    public synchronized LinkedList<NsuObjectHolder<TCEvento>> getEventos_v1_01() {
        return this.getCache("adn_eventos_v1_01");
    }

    private <V> LinkedList<V> getCache(String key) {
        return this.caches.computeIfAbsent(key, k -> new LinkedList());
    }

    public void loadFromFile() {
        if (!this.loaded) {
            if (Files.exists(this.cachePath, new LinkOption[0])) {
                log.info("Carregando cache de arquivo...");
                try {
                    GZIPInputStream inputStream = new GZIPInputStream(Files.newInputStream(this.cachePath, new OpenOption[0]));
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode map = mapper.readTree((InputStream)inputStream);
                    1 typeEvento = new /* Unavailable Anonymous Inner Class!! */;
                    2 typeEvento_v1_01 = new /* Unavailable Anonymous Inner Class!! */;
                    this.caches.put("adn_eventos", new LinkedList((Collection)mapper.readValue(Optional.ofNullable(map.get("adn_eventos")).map(Object::toString).orElse("[]"), (TypeReference)typeEvento)));
                    this.caches.put("adn_eventos_v1_01", new LinkedList((Collection)mapper.readValue(Optional.ofNullable(map.get("adn_eventos_v1_01")).map(Object::toString).orElse("[]"), (TypeReference)typeEvento_v1_01)));
                    this.loaded = true;
                    return;
                }
                catch (IOException e) {
                    log.debug("Erro ao carregar arquivo de cache: tentando apagar", (Throwable)e);
                    try {
                        Files.deleteIfExists(this.cachePath);
                    }
                    catch (IOException ex) {
                        log.error("Erro ao tratar arquivo de cache: {}", (Object)e, (Object)e);
                    }
                }
            }
            log.warn("Arquivo de cache n\u00e3o existente");
            return;
        }
        log.warn("Aten\u00e7\u00e3o! Houve uma tentativa de carregamento do cache, sendo que j\u00e1 foi carregado!");
    }

    public void dumpToFile() {
        if (!Files.exists(this.cachePath, new LinkOption[0])) {
            Files.createFile(this.cachePath, new FileAttribute[0]);
        }
        ObjectMapper mapper = new ObjectMapper();
        GZIPOutputStream outputStream = new GZIPOutputStream(Files.newOutputStream(this.cachePath, new OpenOption[0]));
        try {
            outputStream.write(mapper.writeValueAsBytes((Object)this.caches));
            outputStream.flush();
        }
        finally {
            if (Collections.singletonList(outputStream).get(0) != null) {
                outputStream.close();
            }
        }
    }

    @PreDestroy
    private void destroy() {
        log.debug("Dumping cache to file");
        this.dumpToFile();
    }
}

