/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.model.LiMovimentoeco;
import br.com.fiorilli.nfse_nacional.model.LiMovimentoecoPK;
import br.com.fiorilli.nfse_nacional.model.enums.OrigemGuia;
import br.com.fiorilli.nfse_nacional.model.enums.OrigemMovimento;
import br.com.fiorilli.nfse_nacional.model.enums.TipoEscrituracaoMovimento;
import br.com.fiorilli.nfse_nacional.services.data.LiMovimentoecoService;
import java.time.LocalDate;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class MovimentoService {
    private static final Logger log = LoggerFactory.getLogger(MovimentoService.class);
    private final LiMovimentoecoService liMovimentoecoService;
    private final ReentrantLock lock = new ReentrantLock();

    @Cacheable(cacheNames={"movimento-eco"})
    public LiMovimentoeco recuperarMovimento(LocalDate competencia, int modulo, String cadastro, String codCnt, OrigemMovimento origem) {
        int ano = competencia.getYear();
        int mes = competencia.getMonthValue();
        log.debug("Recuperando movimento {} {} {} {} {} {}", new Object[]{ano, mes, modulo, cadastro, codCnt, origem});
        this.lock.lock();
        try {
            String tipoMovimento = origem == OrigemMovimento.TOMADOR_COMPLETA ? OrigemGuia.DEC_TOMADOR.getValor() : OrigemGuia.DEC_PRESTADOR.getValor();
            String tipoEscritura = TipoEscrituracaoMovimento.NORMAL.getSigla();
            LiMovimentoeco liMovimentoeco = this.recuperarMovimento(cadastro, modulo, mes, ano, origem.getValor(), tipoMovimento, tipoEscritura).orElseGet(() -> {
                log.trace("Movimento n\u00e3o encontrado, gerando novo...");
                return this.gerarNovoMovimento(modulo, cadastro, codCnt, ano, mes, origem.getValor(), tipoMovimento, tipoEscritura);
            });
            return liMovimentoeco;
        }
        catch (Exception e) {
            throw new FiorilliException("Falha na recupera\u00e7\u00e3o de movimento", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public LiMovimentoeco gerarNovoMovimento(int codMod, String cadastro, String codCnt, int ano, int mes, String origem, String tipo, String tipoEscritura) {
        log.debug("Gerando movimento {} {} {} {} {} {} {} {}", new Object[]{codMod, cadastro, codCnt, ano, mes, origem, tipo, tipoEscritura});
        LiMovimentoeco liMovimentoeco = LiMovimentoeco.builder().liMovimentoecoPK(new LiMovimentoecoPK(Integer.valueOf(1), null)).anoMec(Integer.valueOf(ano)).cadastroMec(cadastro).codCntMec(codCnt).codModMec(codMod).datafechadoMec(new Date()).fechadoMec("S").mesMec(Integer.valueOf(mes)).origemMec(origem).loginIncMec("nfse-nac").tipoescrituraMec(tipoEscritura).tpMec(tipo).build();
        return this.liMovimentoecoService.persist(liMovimentoeco);
    }

    public Optional<LiMovimentoeco> recuperarMovimento(String cadastro, int modulo, int mes, int ano, String origem, String tipo, String tipoEscritura) {
        return this.liMovimentoecoService.recuperarMovimento(cadastro, modulo, mes, ano, origem, tipo, tipoEscritura);
    }

    public MovimentoService(LiMovimentoecoService liMovimentoecoService) {
        this.liMovimentoecoService = liMovimentoecoService;
    }
}

