/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.config.ShutdownHook;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.exception.ShutdownSignalException;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscal;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalPK;
import br.com.fiorilli.nfse_nacional.model.LiNotasubcancelada;
import br.com.fiorilli.nfse_nacional.model.enums.StatusNfs;
import br.com.fiorilli.nfse_nacional.schema.NFSeVO;
import br.com.fiorilli.nfse_nacional.services.MobiliarioService;
import br.com.fiorilli.nfse_nacional.services.UtilService;
import br.com.fiorilli.nfse_nacional.services.data.LiNotafiscalService;
import br.com.fiorilli.nfse_nacional.services.data.LiNotasubcanceladaService;
import br.com.fiorilli.nfse_nacional.utils.NsuObjectHolder;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NFSeRecebimentoService {
    private static final Logger log = LoggerFactory.getLogger(NFSeRecebimentoService.class);
    public final EntidadeVO beanEntidade;
    private final LiNotafiscalService liNotafiscalService;
    private final LiNotasubcanceladaService liNotasubcanceladaService;
    private final MobiliarioService mobiliarioService;
    private final UtilService utilService;
    public final Map<String, LiNotafiscal> updateNotasCache = new HashMap();
    private String codigoCidade;

    @PostConstruct
    private void init() {
        this.codigoCidade = String.valueOf(this.utilService.findMunicipio(this.beanEntidade.getCodigoIbge()).getCdMunicipio());
    }

    public void notasParaAtualizar(List<NsuObjectHolder<NFSeVO>> holders) {
        List<String> ids = holders.stream().map(holder -> {
            if (((NFSeVO)holder.getObject()).is_v1_00()) {
                return ((NFSeVO)holder.getObject()).get_v1_00().getInfNFSe().getId().substring(3);
            }
            if (((NFSeVO)holder.getObject()).is_v1_01()) {
                return ((NFSeVO)holder.getObject()).get_v1_01().getInfNFSe().getId().substring(3);
            }
            throw new IllegalStateException("Somente suportadas vers\u00f5es 1.00 e 1.01 dos XSD's");
        }).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            this.liNotafiscalService.notasCadastradasPorCodseguranca(ids).forEach(nota -> {
                if (this.updateNotasCache.containsKey(nota.getCodsegurancaNfs())) {
                    LiNotafiscal notaJaAchada = (LiNotafiscal)this.updateNotasCache.get(nota.getCodsegurancaNfs());
                    if (notaJaAchada.getPk().getCodNfs() > nota.getPk().getCodNfs()) {
                        this.updateNotasCache.replace(nota.getCodsegurancaNfs(), nota);
                        try {
                            this.liNotafiscalService.delete(notaJaAchada);
                        }
                        catch (HibernateException e) {
                            if (e.getMessage().contains("FK_LI_GUIASISSNOTA_LI_NOTAFIS")) {
                                this.liNotafiscalService.delete(nota);
                            }
                            throw e;
                        }
                    } else {
                        try {
                            this.liNotafiscalService.delete(nota);
                        }
                        catch (HibernateException e) {
                            if (e.getMessage().contains("FK_LI_GUIASISSNOTA_LI_NOTAFIS")) {
                                this.liNotafiscalService.delete(notaJaAchada);
                            }
                            throw e;
                        }
                    }
                } else {
                    log.debug("Armazenando nota em cache: {}", (Object)nota.getPk());
                    this.updateNotasCache.put(nota.getCodsegurancaNfs(), nota);
                }
            });
            ids.forEach(id -> {
                if (!this.updateNotasCache.containsKey(id)) {
                    log.debug("Nota n\u00e3o presente: {}", id);
                }
            });
        }
    }

    public List<NsuObjectHolder<NFSeVO>> apenasNotasNovas(List<NsuObjectHolder<NFSeVO>> holders) {
        List<Long> nsus = holders.stream().map(NsuObjectHolder::getNsu).toList();
        List cadastrados = this.liNotafiscalService.nsusCadastrados(nsus);
        cadastrados.sort(Long::compare);
        log.trace("Cadastrados com NSU: {}", (Object)cadastrados);
        ArrayList<NsuObjectHolder<NFSeVO>> holdersSorted = new ArrayList<NsuObjectHolder<NFSeVO>>(holders);
        holdersSorted.sort(Comparator.comparing(NsuObjectHolder::getNsu));
        int i = 0;
        int j = 0;
        while (i < holdersSorted.size() && j < cadastrados.size()) {
            long nsuCadastrado;
            long nsuHolder = holdersSorted.get(i).getNsu();
            if (nsuHolder == (nsuCadastrado = ((Long)cadastrados.get(j)).longValue())) {
                log.debug("Nota existente {}", (Object)nsuCadastrado);
                holdersSorted.remove(i);
                ++j;
                continue;
            }
            if (nsuHolder > nsuCadastrado) {
                ++j;
                continue;
            }
            ++i;
        }
        return holdersSorted;
    }

    public void saveCancelamento(String chaveNotaCancelada, LiNotasubcancelada cancelamento, StatusNfs statusNfs) {
        if (ShutdownHook.shutdownInitiaded.get()) {
            throw new ShutdownSignalException();
        }
        Optional optNota = this.liNotafiscalService.findNotaByChave(chaveNotaCancelada);
        if (optNota.isPresent()) {
            LiNotafiscal linota = (LiNotafiscal)optNota.get();
            if (linota.getStatusNfs() == StatusNfs.CANCELADA || linota.getStatusNfs() == StatusNfs.SUBSTITUIDA) {
                log.debug("Nota de chave {} j\u00e1 cancelada", (Object)chaveNotaCancelada);
                return;
            }
            cancelamento.setPk(new LiNotafiscalPK(linota.getPk().getCodEmpNfs(), linota.getPk().getCodNfs()));
            log.debug("Salvando LiNotasubcancelada: {}", (Object)cancelamento.getPk());
            this.liNotasubcanceladaService.merge(cancelamento);
            linota.setStatusNfs(statusNfs);
            this.liNotafiscalService.save(linota);
        }
    }

    public void cleanup() {
        this.mobiliarioService.cleanupCache();
        this.utilService.cleanDbAccess();
        this.updateNotasCache.clear();
    }

    public NFSeRecebimentoService(EntidadeVO beanEntidade, LiNotafiscalService liNotafiscalService, LiNotasubcanceladaService liNotasubcanceladaService, MobiliarioService mobiliarioService, UtilService utilService) {
        this.beanEntidade = beanEntidade;
        this.liNotafiscalService = liNotafiscalService;
        this.liNotasubcanceladaService = liNotasubcanceladaService;
        this.mobiliarioService = mobiliarioService;
        this.utilService = utilService;
    }

    public String getCodigoCidade() {
        return this.codigoCidade;
    }
}

