/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.dto.NotaEnvioVO;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.model.GrContribuintes;
import br.com.fiorilli.nfse_nacional.model.LiMobil;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscal;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalNacional;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalPK;
import br.com.fiorilli.nfse_nacional.model.enums.StatusEnvioNotaNacional;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCDPS;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCNFSe;
import br.com.fiorilli.nfse_nacional.services.DPSBuildService_v1_00;
import br.com.fiorilli.nfse_nacional.services.NFSeBuildService_v1_00;
import br.com.fiorilli.nfse_nacional.services.UtilService;
import br.com.fiorilli.nfse_nacional.services.data.GrContribuintesService;
import br.com.fiorilli.nfse_nacional.services.data.LiMobilService;
import br.com.fiorilli.nfse_nacional.services.data.LiNotafiscalService;
import br.com.fiorilli.nfse_nacional.utils.BuildXmlUtils;
import br.com.fiorilli.nfse_nacional.utils.XmlUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.concurrent.CompletableFuture;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NotaFiscalEnvioService_v1_00 {
    private static final Logger log = LoggerFactory.getLogger(NotaFiscalEnvioService_v1_00.class);
    private final Jaxb2Marshaller DPSMarshaller_v1_00;
    private final Jaxb2Marshaller NFSeMarshaller_v1_00;
    private final EntidadeVO entidadeVO;
    private final LiNotafiscalService liNotafiscalService;
    private final GrContribuintesService grContribuintesService;
    private final NFSeBuildService_v1_00 nfseBuildService_v1_00;
    private final DPSBuildService_v1_00 dpsBuildService_v1_00;
    private final LiMobilService liMobilService;
    private final UtilService utilService;

    public String apenasMontarXml(LiNotafiscal liNotafiscal) {
        NotaEnvioVO nota = this.fetchInfosDaNota(liNotafiscal);
        TCDPS dps = this.dpsBuildService_v1_00.buildDps(nota);
        TCNFSe nfse = this.nfseBuildService_v1_00.buildNfse(nota, dps);
        String stringNfse = BuildXmlUtils.removeNamespace((String)XmlUtils.xmlToString((Object)nfse, (Marshaller)this.NFSeMarshaller_v1_00));
        liNotafiscal.getNotaNacional().setChaveNfseNfn(nfse.getInfNFSe().getId().substring(3));
        liNotafiscal.getNotaNacional().setNdfeNfn(Long.valueOf(nfse.getInfNFSe().getNDFSe()));
        CompletableFuture.runAsync(() -> this.liNotafiscalService.merge(liNotafiscal));
        return stringNfse;
    }

    @Transactional
    public String prepararEnvio(LiNotafiscal liNotafiscal) throws Exception {
        if (liNotafiscal.getNotaNacional() == null) {
            liNotafiscal.setNotaNacional(this.montarDadosNacional(liNotafiscal.getPk()));
        }
        byte[] pkcs12 = this.entidadeVO.getCertificado();
        char[] password = this.entidadeVO.getSenhaCertificado().toCharArray();
        NotaEnvioVO nota = this.fetchInfosDaNota(liNotafiscal);
        TCDPS dps = this.dpsBuildService_v1_00.buildDps(nota);
        String stringDps = BuildXmlUtils.removeNamespace((String)XmlUtils.xmlToString((Object)dps, (Marshaller)this.DPSMarshaller_v1_00));
        String rawSignedDps = BuildXmlUtils.removeNamespace((String)XmlUtils.sign((byte[])stringDps.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "").getBytes(), (byte[])pkcs12, (char[])password));
        TCDPS signedDps = (TCDPS)XmlUtils.stringToXml((String)rawSignedDps, (Unmarshaller)this.DPSMarshaller_v1_00);
        dps.setSignature(signedDps.getSignature());
        TCNFSe nfse = this.nfseBuildService_v1_00.buildNfse(nota, dps);
        String stringNfse = XmlUtils.xmlToString((Object)nfse, (Marshaller)this.NFSeMarshaller_v1_00);
        String rawXml = XmlUtils.sign((byte[])stringNfse.getBytes(), (byte[])pkcs12, (char[])password);
        liNotafiscal.getNotaNacional().setChaveNfseNfn(nfse.getInfNFSe().getId().substring(3));
        liNotafiscal.getNotaNacional().setNdfeNfn(Long.valueOf(nfse.getInfNFSe().getNDFSe()));
        this.liNotafiscalService.merge(liNotafiscal);
        if (log.isDebugEnabled()) {
            System.out.println(NotaFiscalEnvioService_v1_00.prettyPrintByTransformer((String)rawXml, (int)2, (boolean)true));
        }
        return rawXml;
    }

    private LiNotafiscalNacional montarDadosNacional(LiNotafiscalPK pk) {
        LiNotafiscalNacional liNotafiscalNacional = new LiNotafiscalNacional();
        liNotafiscalNacional.setStatusEnvioNac(StatusEnvioNotaNacional.NAO_ENVIADA);
        liNotafiscalNacional.setPk(pk);
        return this.liNotafiscalService.save(liNotafiscalNacional);
    }

    private NotaEnvioVO fetchInfosDaNota(LiNotafiscal liNotafiscal) {
        NotaEnvioVO nota = new NotaEnvioVO(liNotafiscal);
        if (nota.getLiNotafiscal().getCodModNfs() == 2) {
            nota.setLiMobil((LiMobil)this.liMobilService.findByCodigo(nota.getLiNotafiscal().getCadastroNfs()).orElseThrow());
            nota.setGrContribuintes(nota.getLiMobil().getGrContribuintes());
        } else if (nota.getLiNotafiscal().getCodModNfs() == 5) {
            nota.setGrContribuintes((GrContribuintes)this.grContribuintesService.findByCodigo(nota.getLiNotafiscal().getCadastroNfs()).orElseThrow());
        }
        if (nota.getLiMobil() != null) {
            nota.setMunicipioCadstro(this.utilService.findMunicipio(this.entidadeVO.getCodigoIbge()));
        } else {
            nota.setMunicipioCadstro(this.utilService.findMunicipioByGrCidade(nota.getCodCidCadastro()));
        }
        return nota;
    }

    public static String prettyPrintByTransformer(String xmlString, int indent, boolean ignoreDeclaration) {
        try {
            InputSource src = new InputSource(new StringReader(xmlString));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", ignoreDeclaration ? "yes" : "no");
            transformer.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurs when pretty-printing xml:\n" + xmlString, e);
        }
    }

    public NotaFiscalEnvioService_v1_00(Jaxb2Marshaller DPSMarshaller_v1_00, Jaxb2Marshaller NFSeMarshaller_v1_00, EntidadeVO entidadeVO, LiNotafiscalService liNotafiscalService, GrContribuintesService grContribuintesService, NFSeBuildService_v1_00 nfseBuildService_v1_00, DPSBuildService_v1_00 dpsBuildService_v1_00, LiMobilService liMobilService, UtilService utilService) {
        this.DPSMarshaller_v1_00 = DPSMarshaller_v1_00;
        this.NFSeMarshaller_v1_00 = NFSeMarshaller_v1_00;
        this.entidadeVO = entidadeVO;
        this.liNotafiscalService = liNotafiscalService;
        this.grContribuintesService = grContribuintesService;
        this.nfseBuildService_v1_00 = nfseBuildService_v1_00;
        this.dpsBuildService_v1_00 = dpsBuildService_v1_00;
        this.liMobilService = liMobilService;
        this.utilService = utilService;
    }
}

