/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.config.Constants;
import br.com.fiorilli.nfse_nacional.config.ShutdownHook;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.exception.NotaExistenteException;
import br.com.fiorilli.nfse_nacional.exception.ShutdownSignalException;
import br.com.fiorilli.nfse_nacional.model.GrContribuintes;
import br.com.fiorilli.nfse_nacional.model.LiAtivdesdo;
import br.com.fiorilli.nfse_nacional.model.LiConfig;
import br.com.fiorilli.nfse_nacional.model.LiMobil;
import br.com.fiorilli.nfse_nacional.model.LiMovimentoeco;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscal;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalDocdedred;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalDocdedredPK;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalItens;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalItensPK;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalNacional;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalPK;
import br.com.fiorilli.nfse_nacional.model.LiNotaintermediario;
import br.com.fiorilli.nfse_nacional.model.Municipio;
import br.com.fiorilli.nfse_nacional.model.enums.MecanismoComercioExteriorPrestador;
import br.com.fiorilli.nfse_nacional.model.enums.MecanismoComercioExteriorTomador;
import br.com.fiorilli.nfse_nacional.model.enums.ModoPrestacaoExportacao;
import br.com.fiorilli.nfse_nacional.model.enums.OrigemMovimento;
import br.com.fiorilli.nfse_nacional.model.enums.ResponsavelRetencao;
import br.com.fiorilli.nfse_nacional.model.enums.SimNao;
import br.com.fiorilli.nfse_nacional.model.enums.StatusEnvioNotaNacional;
import br.com.fiorilli.nfse_nacional.model.enums.StatusNfs;
import br.com.fiorilli.nfse_nacional.model.enums.TipoNota;
import br.com.fiorilli.nfse_nacional.model.enums.TipoRetencaoPisCofins;
import br.com.fiorilli.nfse_nacional.model.enums.TributacaoIssqn;
import br.com.fiorilli.nfse_nacional.model.enums.VinculoOperacaoBens;
import br.com.fiorilli.nfse_nacional.model.enums.VinculoPartesExportacao;
import br.com.fiorilli.nfse_nacional.schema.enums.SituacaoNfse;
import br.com.fiorilli.nfse_nacional.schema.enums.SituacaoSimplesNacional;
import br.com.fiorilli.nfse_nacional.schema.enums.SituacaoTributariaPisCofins;
import br.com.fiorilli.nfse_nacional.schema.enums.TipoEmitenteDPS;
import br.com.fiorilli.nfse_nacional.schema.enums.TipoImunidadeIssqn;
import br.com.fiorilli.nfse_nacional.schema.enums.TipoRetencaoISSQN;
import br.com.fiorilli.nfse_nacional.schema.v100.common.TCEnderObraEvento;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCAtvEvento;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCComExterior;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCDocDedRed;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCEnderExt;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCEnderExtSimples;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCEndereco;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCExigSuspensa;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCInfDPS;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCInfNFSe;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCInfoObra;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCInfoPessoa;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCInfoPrestador;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCInfoValores;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCNFSe;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCServ;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCTribFederal;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCTribMunicipal;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCTribOutrosPisCofins;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCTribTotal;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCTribTotalMonet;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCTribTotalPercent;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCVDescCondIncond;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCValoresNFSe;
import br.com.fiorilli.nfse_nacional.services.ConfigService;
import br.com.fiorilli.nfse_nacional.services.ContribuinteService;
import br.com.fiorilli.nfse_nacional.services.MobiliarioService;
import br.com.fiorilli.nfse_nacional.services.MovimentoService;
import br.com.fiorilli.nfse_nacional.services.NFSeRecebimentoService;
import br.com.fiorilli.nfse_nacional.services.NotaFiscalRecebimentoService_v1_00;
import br.com.fiorilli.nfse_nacional.services.UtilService;
import br.com.fiorilli.nfse_nacional.services.data.LiAtivdesdoService;
import br.com.fiorilli.nfse_nacional.services.data.LiNotafiscalService;
import br.com.fiorilli.nfse_nacional.services.data.LiServicoNbsService;
import br.com.fiorilli.nfse_nacional.utils.FiorilliUtils;
import br.com.fiorilli.nfse_nacional.utils.NFSeUtil;
import br.com.fiorilli.nfse_nacional.utils.NsuObjectHolder;
import jakarta.validation.ConstraintViolationException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NotaFiscalRecebimentoService_v1_00 {
    private static final Logger log = LoggerFactory.getLogger(NotaFiscalRecebimentoService_v1_00.class);
    private final MovimentoService movimentoService;
    private final MobiliarioService mobiliarioService;
    private final ContribuinteService contribuinteService;
    private final UtilService utilService;
    private final LiNotafiscalService liNotafiscalService;
    private final LiAtivdesdoService liAtivdesdoService;
    private final ConfigService configService;
    private final LiServicoNbsService liServicoNbsService;
    private final NFSeRecebimentoService NFSeRecebimentoService;

    public boolean ignorarNota(NsuObjectHolder<TCNFSe> notaHolder) {
        TCNFSe nota = (TCNFSe)notaHolder.getObject();
        TCInfDPS infDPS = nota.getInfNFSe().getDPS().getInfDPS();
        String localEmissao = infDPS.getCLocEmi();
        boolean isEmitidoAqui = this.NFSeRecebimentoService.getCodigoCidade().equals(localEmissao);
        if (isEmitidoAqui) {
            return false;
        }
        String localIncidenciaIss = nota.getInfNFSe().getCLocIncid();
        boolean isIncidenteAqui = this.NFSeRecebimentoService.getCodigoCidade().equals(localIncidenciaIss);
        if (isIncidenteAqui) {
            return false;
        }
        String localPrestacao = infDPS.getServ().getLocPrest().getCLocPrestacao();
        boolean isPrestacaoAqui = this.NFSeRecebimentoService.getCodigoCidade().equals(localPrestacao);
        if (isPrestacaoAqui) {
            return false;
        }
        TipoRetencaoISSQN tipoRetencao = TipoRetencaoISSQN.of((String)infDPS.getValores().getTrib().getTribMun().getTpRetISSQN());
        if (tipoRetencao != TipoRetencaoISSQN.NAO_RETIDO) {
            String codigoMunicipioTomador = null;
            TCEndereco endToma = infDPS.getToma().getEnd();
            if (endToma != null && endToma.getEndNac() != null) {
                codigoMunicipioTomador = endToma.getEndNac().getCMun();
            }
            boolean isTomadorDaqui = this.NFSeRecebimentoService.getCodigoCidade().equals(codigoMunicipioTomador);
            if (tipoRetencao == TipoRetencaoISSQN.RETIDO_TOMADOR && isTomadorDaqui) {
                return false;
            }
            if (infDPS.getInterm() != null) {
                String codigoMunicipioIntermediario = null;
                TCEndereco endInter = infDPS.getInterm().getEnd();
                if (endInter != null && endInter.getEndNac() != null) {
                    codigoMunicipioIntermediario = endInter.getEndNac().getCMun();
                }
                boolean isIntermediarioDaqui = this.NFSeRecebimentoService.getCodigoCidade().equals(codigoMunicipioIntermediario);
                if (tipoRetencao == TipoRetencaoISSQN.RETIDO_INTERMEDIARIO && isIntermediarioDaqui) {
                    return false;
                }
            }
        }
        return true;
    }

    public LiNotafiscal processLiNota(NsuObjectHolder<TCNFSe> tcnfSeHolder) {
        LiNotafiscal liNotafiscal = (LiNotafiscal)this.NFSeRecebimentoService.updateNotasCache.get(((TCNFSe)tcnfSeHolder.getObject()).getInfNFSe().getId().substring(3));
        if (liNotafiscal == null) {
            liNotafiscal = new LiNotafiscal();
            liNotafiscal.setPk(new LiNotafiscalPK(Integer.valueOf(1), null));
            LiNotafiscalNacional notaNacional = new LiNotafiscalNacional();
            notaNacional.setPk(liNotafiscal.getPk());
            notaNacional.setStatusEnvioNac(StatusEnvioNotaNacional.IMPORTADA);
            liNotafiscal.setNotaNacional(notaNacional);
        } else {
            this.liNotafiscalService.refreshNota(liNotafiscal);
            if (liNotafiscal.getNotaNacional() == null) {
                LiNotafiscalNacional notaNacional = new LiNotafiscalNacional();
                notaNacional.setPk(liNotafiscal.getPk());
                notaNacional.setStatusEnvioNac(StatusEnvioNotaNacional.IMPORTADA);
                liNotafiscal.setNotaNacional(notaNacional);
            }
        }
        return this.processLiNota(tcnfSeHolder, liNotafiscal);
    }

    public LiNotafiscal processLiNota(NsuObjectHolder<TCNFSe> tcnfSeHolder, LiNotafiscal liNotafiscal) {
        TCNFSe tcnfSe = (TCNFSe)tcnfSeHolder.getObject();
        TCInfDPS infDPS = tcnfSe.getInfNFSe().getDPS().getInfDPS();
        TipoRetencaoISSQN tipoRetencao = TipoRetencaoISSQN.of((String)infDPS.getValores().getTrib().getTribMun().getTpRetISSQN());
        liNotafiscal.setAdnNsuNfs(tcnfSeHolder.getNsu());
        this.preencherTomador(liNotafiscal, infDPS.getToma());
        liNotafiscal.setStatusNfs(StatusNfs.NORMAL);
        boolean naoRetido = TipoRetencaoISSQN.NAO_RETIDO == tipoRetencao;
        liNotafiscal.setImpostoretidoNfs(naoRetido ? SimNao.NAO : SimNao.SIM);
        liNotafiscal.setResponsavelretencaoNfs(naoRetido ? null : (TipoRetencaoISSQN.RETIDO_INTERMEDIARIO == tipoRetencao ? ResponsavelRetencao.INTERMEDIARIO : ResponsavelRetencao.TOMADOR));
        if (tcnfSe.getInfNFSe().getCLocIncid() != null) {
            liNotafiscal.setIssqnforamunicipioNfs(tcnfSe.getInfNFSe().getCLocIncid().equals(this.NFSeRecebimentoService.beanEntidade.getCodigoIbge().toString()) ? SimNao.NAO : SimNao.SIM);
        }
        LocalDateTime dataHoraEmissao = FiorilliUtils.toDateTime((String)infDPS.getDhEmi());
        liNotafiscal.setDataemissaoNfs(dataHoraEmissao.toLocalDate());
        liNotafiscal.setHoraemissaoNfs(dataHoraEmissao.toLocalTime());
        liNotafiscal.setCdMunicipioincidenciaissNfs(NumberUtils.createInteger((String)((String)StringUtils.defaultIfBlank((CharSequence)tcnfSe.getInfNFSe().getCLocIncid(), null))));
        liNotafiscal.setCdMunicipioprestacaoNfs(NumberUtils.createInteger((String)((String)StringUtils.defaultIfBlank((CharSequence)infDPS.getServ().getLocPrest().getCLocPrestacao(), null))));
        liNotafiscal.setCdPaisprestacaoNfs(Optional.ofNullable(this.utilService.findCodBceByIso2(infDPS.getServ().getLocPrest().getCPaisPrestacao())).orElse(1058));
        liNotafiscal.setCodsegurancaNfs(tcnfSe.getInfNFSe().getId().substring(3));
        liNotafiscal.getNotaNacional().setChaveNfseNfn(tcnfSe.getInfNFSe().getId().substring(3));
        liNotafiscal.setDatacompeteNfs(FiorilliUtils.toDate((String)infDPS.getDCompet()));
        liNotafiscal.setRegimeespecialtribNfs(NFSeUtil.regimeNacionalParaNosso((TCInfNFSe)tcnfSe.getInfNFSe()));
        liNotafiscal.setOptantesimplesNfs(switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$schema$enums$SituacaoSimplesNacional[SituacaoSimplesNacional.of((String)infDPS.getPrest().getRegTrib().getOpSimpNac()).ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> SimNao.NAO;
            case 2, 3 -> SimNao.SIM;
        });
        NotaFiscalRecebimentoService_v1_00.checkShutdown();
        NotaFiscalRecebimentoService_v1_00.preencherTributos((TCNFSe)tcnfSe, (LiNotafiscal)liNotafiscal);
        this.preencherPrestador(tcnfSe, liNotafiscal);
        this.preencherMovimento(tcnfSe, liNotafiscal);
        liNotafiscal.setNrnotaNfs(Long.valueOf(tcnfSe.getInfNFSe().getNNFSe()));
        LiConfig liconfig = this.configService.findConfiguracao();
        liNotafiscal.setCodSnfNfs(liconfig.getCodserienfenacCnf());
        liNotafiscal.setCodEnfNfs(liconfig.getCodespecienfeCnf());
        if (infDPS.getServ().getInfoCompl() != null) {
            liNotafiscal.setObsNfs(infDPS.getServ().getInfoCompl().getXInfComp());
        }
        NotaFiscalRecebimentoService_v1_00.checkShutdown();
        return liNotafiscal;
    }

    public void salvarPreencherDados(TCNFSe nfse, LiNotafiscal liNotafiscal) {
        try {
            LiNotafiscalItens item;
            NotaFiscalRecebimentoService_v1_00.checkShutdown();
            log.trace("Salvando a nota {}", (Object)liNotafiscal.getAdnNsuNfs());
            if (liNotafiscal.getPk().getCodNfs() != null) {
                this.liNotafiscalService.refreshNota(liNotafiscal);
            }
            if ((item = liNotafiscal.getItemServico()) == null) {
                item = new LiNotafiscalItens();
                item.setPk(new LiNotafiscalItensPK(Integer.valueOf(1), liNotafiscal.getPk().getCodNfs(), Integer.valueOf(1)));
                item.setLiNotafiscal(liNotafiscal);
                liNotafiscal.setItemServico(item);
            }
            this.preencherServico(nfse, item);
            TCInfoPessoa interm = nfse.getInfNFSe().getDPS().getInfDPS().getInterm();
            if (interm != null) {
                LiNotaintermediario intermediario = liNotafiscal.getIntermediario();
                if (intermediario == null) {
                    intermediario = new LiNotaintermediario();
                    intermediario.setPk(liNotafiscal.getPk());
                    intermediario.setLiNotafiscal(liNotafiscal);
                    liNotafiscal.setIntermediario(intermediario);
                }
                this.preencherIntermediario(interm, intermediario);
            }
            NotaFiscalRecebimentoService_v1_00.preencherDocumentosDeducao((TCNFSe)nfse, (LiNotafiscal)liNotafiscal);
            NotaFiscalRecebimentoService_v1_00.preencherObra((TCNFSe)nfse, (LiNotafiscalNacional)liNotafiscal.getNotaNacional());
            NotaFiscalRecebimentoService_v1_00.preencherEvento((TCNFSe)nfse, (LiNotafiscalNacional)liNotafiscal.getNotaNacional());
            NotaFiscalRecebimentoService_v1_00.preencherComercioExterior((TCNFSe)nfse, (LiNotafiscalNacional)liNotafiscal.getNotaNacional());
            liNotafiscal = this.liNotafiscalService.save(liNotafiscal);
            this.NFSeRecebimentoService.updateNotasCache.remove(liNotafiscal.getCodsegurancaNfs());
            log.debug("Processamento concluido, retornando nota {}", (Object)liNotafiscal.getAdnNsuNfs());
        }
        catch (ConstraintViolationException e) {
            throw new FiorilliException("Erro de valida\u00e7\u00e3o! " + String.valueOf(e.getConstraintViolations()), (Throwable)e);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("TRG_LI_NOTAFISCAL_NRONOTA") && e.getMessage().contains("NSU_NOTA") || e.getCause() != null && e.getCause().getMessage().contains("TRG_LI_NOTAFISCAL_NRONOTA") && e.getCause().getMessage().contains("NSU_NOTA")) {
                throw new NotaExistenteException();
            }
            throw e;
        }
    }

    private static void preencherDocumentosDeducao(TCNFSe nfse, LiNotafiscal liNotafiscal) {
        if (nfse.getInfNFSe().getDPS().getInfDPS().getValores().getVDedRed() != null && nfse.getInfNFSe().getDPS().getInfDPS().getValores().getVDedRed().getDocumentos() != null) {
            if (liNotafiscal.getLiNotafiscalDocdedreds() == null) {
                liNotafiscal.setLiNotafiscalDocdedreds(new ArrayList());
            }
            int i = 1;
            for (TCDocDedRed doc : nfse.getInfNFSe().getDPS().getInfDPS().getValores().getVDedRed().getDocumentos().getDocDedRed()) {
                LiNotafiscalDocdedred docdedred = new LiNotafiscalDocdedred();
                docdedred.setPk(new LiNotafiscalDocdedredPK(liNotafiscal.getPk().getCodEmpNfs(), liNotafiscal.getPk().getCodNfs(), Integer.valueOf(i++)));
                String chave = (String)StringUtils.defaultIfBlank((CharSequence)doc.getChNFSe(), (CharSequence)doc.getChNFe());
                if (chave != null) {
                    docdedred.setChaveNfseNfd(chave);
                } else if (doc.getNFSeMun() != null) {
                    docdedred.setCmunNfsemunNfd(Integer.valueOf(doc.getNFSeMun().getCMunNFSeMun()));
                    docdedred.setNnfseNfsemunNfd(Long.valueOf(doc.getNFSeMun().getNNFSeMun()));
                    docdedred.setVerifNfsemunNfd(doc.getNFSeMun().getCVerifNFSeMun());
                } else if (doc.getNFNFS() != null) {
                    docdedred.setNnfsNfNfd(Integer.valueOf(doc.getNFNFS().getNNFS()));
                    docdedred.setModnfsNfNfd(Integer.valueOf(doc.getNFNFS().getModNFS()));
                    docdedred.setSerienfsNfNfd(doc.getNFNFS().getSerieNFS());
                } else if (doc.getNDocFisc() != null) {
                    docdedred.setNdocfiscNfd(doc.getNDocFisc());
                } else {
                    docdedred.setNdocNfd(doc.getNDoc());
                }
                docdedred.setTpdedredNfd(doc.getTpDedRed());
                docdedred.setXdescdedNfd(doc.getXDescOutDed());
                LocalDate dataEmi = doc.getDtEmiDoc().toGregorianCalendar().getTime().toInstant().atZone(doc.getDtEmiDoc().toGregorianCalendar().getTimeZone().toZoneId()).toLocalDate();
                docdedred.setDtemidocNfd(dataEmi);
                docdedred.setVdedutivelNfd(Double.valueOf(doc.getVDedutivelRedutivel()));
                docdedred.setVdeducaoNfd(Double.valueOf(doc.getVDeducaoReducao()));
                if (doc.getFornec() != null) {
                    docdedred.setCpfcnpjForNfd((String)StringUtils.defaultIfBlank((CharSequence)doc.getFornec().getCNPJ(), (CharSequence)doc.getFornec().getCPF()));
                    docdedred.setNifForNfd(doc.getFornec().getNIF());
                    docdedred.setCnaonifForNfd(doc.getFornec().getCNaoNIF());
                    docdedred.setImForNfd(doc.getFornec().getIM());
                    docdedred.setNomeForNfd(doc.getFornec().getXNome());
                    if (doc.getFornec().getEnd() != null) {
                        if (doc.getFornec().getEnd().getEndNac() != null) {
                            docdedred.setCmunForNfd(Integer.valueOf(doc.getFornec().getEnd().getEndNac().getCMun()));
                            docdedred.setCepForNfd(doc.getFornec().getEnd().getEndNac().getCEP());
                        }
                        if (doc.getFornec().getEnd().getEndExt() != null) {
                            docdedred.setCpaisForNfd(doc.getFornec().getEnd().getEndExt().getCPais());
                            docdedred.setCendpostForNfd(doc.getFornec().getEnd().getEndExt().getCEndPost());
                            docdedred.setCidadextForNfd(doc.getFornec().getEnd().getEndExt().getXCidade());
                            docdedred.setProvextForNfd(doc.getFornec().getEnd().getEndExt().getXEstProvReg());
                        }
                        docdedred.setLograForNfd(doc.getFornec().getEnd().getXLgr());
                        docdedred.setNroForNfd(doc.getFornec().getEnd().getNro());
                        docdedred.setBairroForNfd(doc.getFornec().getEnd().getXBairro());
                        docdedred.setComplForNfd(doc.getFornec().getEnd().getXCpl());
                    }
                }
                docdedred.setFoneForNfd(doc.getFornec().getFone());
                docdedred.setEmailForNfd(doc.getFornec().getEmail());
                liNotafiscal.getLiNotafiscalDocdedreds().add(docdedred);
            }
        }
    }

    private static void preencherObra(TCNFSe nfse, LiNotafiscalNacional liNotafiscalNacional) {
        TCInfoObra obra = nfse.getInfNFSe().getDPS().getInfDPS().getServ().getObra();
        if (obra == null) {
            return;
        }
        String inscricaoObra = obra.getInscImobFisc();
        String codigoObra = obra.getCObra();
        TCEnderObraEvento obraEnd = obra.getEnd();
        if (inscricaoObra != null) {
            liNotafiscalNacional.setInscObraNfn(inscricaoObra);
        }
        if (codigoObra != null) {
            liNotafiscalNacional.setCodigoObraNfn(codigoObra);
        } else if (obraEnd != null) {
            liNotafiscalNacional.setLograObraNfn(obraEnd.getXLgr());
            liNotafiscalNacional.setNroObraNfn(obraEnd.getNro());
            liNotafiscalNacional.setComplObraNfn(obraEnd.getXCpl());
            liNotafiscalNacional.setBairroObraNfn(obraEnd.getXBairro());
            String cep = obraEnd.getCEP();
            if (cep != null) {
                liNotafiscalNacional.setCepObraNfn(cep);
            } else {
                TCEnderExtSimples endExt = obraEnd.getEndExt();
                liNotafiscalNacional.setCpostextObraNfn(endExt.getCEndPost());
                liNotafiscalNacional.setCidextObraNfn(endExt.getXCidade());
                liNotafiscalNacional.setProvextObraNfn(endExt.getXEstProvReg());
            }
        }
        if (inscricaoObra == null && codigoObra == null && obraEnd == null) {
            throw new FiorilliException("Obra sem nenhum tipo de identifica\u00e7\u00e3o!");
        }
    }

    private static void preencherEvento(TCNFSe nfse, LiNotafiscalNacional liNotafiscalNacional) {
        TCAtvEvento evento = nfse.getInfNFSe().getDPS().getInfDPS().getServ().getAtvEvento();
        if (evento == null) {
            return;
        }
        liNotafiscalNacional.setNomeEvtoNfn(evento.getXNome());
        liNotafiscalNacional.setDatainiEvtoNfn(FiorilliUtils.toDate((String)evento.getDtIni()));
        liNotafiscalNacional.setDatafimEvtoNfn(FiorilliUtils.toDate((String)evento.getDtFim()));
        String id = evento.getIdAtvEvt();
        if (id != null) {
            liNotafiscalNacional.setIdEvtoNfn(id);
        } else if (evento.getEnd() != null) {
            liNotafiscalNacional.setLograEvtoNfn(evento.getEnd().getXLgr());
            liNotafiscalNacional.setNroEvtoNfn(evento.getEnd().getNro());
            liNotafiscalNacional.setComplEvtoNfn(evento.getEnd().getXCpl());
            liNotafiscalNacional.setBairroEvtoNfn(evento.getEnd().getXBairro());
            String cep = evento.getEnd().getCEP();
            if (cep != null) {
                liNotafiscalNacional.setCepEvtoNfn(cep);
            } else {
                TCEnderExtSimples endExt = evento.getEnd().getEndExt();
                liNotafiscalNacional.setCpostextEvtoNfn(endExt.getCEndPost());
                liNotafiscalNacional.setCidextEvtoNfn(endExt.getXCidade());
                liNotafiscalNacional.setProvextEvtoNfn(endExt.getXEstProvReg());
            }
        } else {
            throw new FiorilliException("Atividade de evento sem ID e sem endere\u00e7o!");
        }
    }

    private static void preencherComercioExterior(TCNFSe nfse, LiNotafiscalNacional liNotafiscalNacional) {
        TCComExterior comExt = nfse.getInfNFSe().getDPS().getInfDPS().getServ().getComExt();
        if (comExt == null) {
            return;
        }
        liNotafiscalNacional.setMdprestacaoComextNfn(ModoPrestacaoExportacao.of((String)comExt.getMdPrestacao()));
        liNotafiscalNacional.setVincprestComextNfn(VinculoPartesExportacao.of((String)comExt.getVincPrest()));
        liNotafiscalNacional.setTpmoedaComextNfn(comExt.getTpMoeda());
        liNotafiscalNacional.setVservmoedaComextNfn(Double.valueOf(NumberUtils.toDouble((String)comExt.getVServMoeda())));
        liNotafiscalNacional.setMecafprestComextNfn(MecanismoComercioExteriorPrestador.of((String)comExt.getMecAFComexP()));
        liNotafiscalNacional.setMecaftomaComextNfn(MecanismoComercioExteriorTomador.of((String)comExt.getMecAFComexT()));
        liNotafiscalNacional.setVincmovbensComextNfn(VinculoOperacaoBens.of((String)comExt.getMovTempBens()));
        liNotafiscalNacional.setNdiComextNfn(comExt.getNDI());
        liNotafiscalNacional.setNreComextNfn(comExt.getNRE());
        liNotafiscalNacional.setMdicComextNfn(switch ((String)StringUtils.defaultIfBlank((CharSequence)comExt.getMdic(), (CharSequence)"")) {
            case "0" -> SimNao.NAO;
            case "1" -> SimNao.SIM;
            case "" -> null;
            default -> throw new IllegalArgumentException("0 ou 1 esperado, mas veio diferente:");
        });
    }

    private void preencherIntermediario(TCInfoPessoa interm, LiNotaintermediario intermediario) {
        intermediario.setNomeRazaosocialNit(interm.getXNome());
        intermediario.setCpfCnpjNit(StringUtils.isNotBlank((CharSequence)interm.getCNPJ()) ? interm.getCNPJ() : interm.getCPF());
        intermediario.setFoneNit(interm.getFone());
        intermediario.setEmailNit(interm.getEmail());
        intermediario.setInscrmNit(interm.getIM());
        if (interm.getEnd() != null) {
            intermediario.setLogradouroNit(StringUtils.truncate((String)interm.getEnd().getXLgr(), (int)128));
            intermediario.setNumeroNit(StringUtils.truncate((String)interm.getEnd().getNro(), (int)10));
            intermediario.setComplementoNit(StringUtils.truncate((String)interm.getEnd().getXCpl(), (int)60));
            intermediario.setBairroNit(interm.getEnd().getXBairro());
            if (interm.getEnd().getEndNac() != null) {
                Municipio municipio = this.utilService.findMunicipio(Integer.valueOf(interm.getEnd().getEndNac().getCMun()));
                intermediario.setCepNit(interm.getEnd().getEndNac().getCEP());
                intermediario.setMunicipioNit(municipio.getMunicipio());
                intermediario.setMunicipio(municipio);
                intermediario.setForapaisNit(SimNao.NAO);
            } else if (interm.getEnd().getEndExt() != null) {
                intermediario.setCpfCnpjNit(interm.getNIF());
                intermediario.setCdPaisNit(this.utilService.findCodBceByIso2(interm.getEnd().getEndExt().getCPais()));
                intermediario.setEstadoProvinciaNit(interm.getEnd().getEndExt().getXEstProvReg());
                intermediario.setMunicipioNit(interm.getEnd().getEndExt().getXCidade());
                intermediario.setForapaisNit(SimNao.SIM);
            }
        }
    }

    private static void preencherTributos(TCNFSe tcnfSe, LiNotafiscal notafiscal) {
        NotaFiscalRecebimentoService_v1_00.checkShutdown();
        log.trace("Preencher tributos nota {}", (Object)notafiscal.getAdnNsuNfs());
        TCInfDPS infDPS = tcnfSe.getInfNFSe().getDPS().getInfDPS();
        TCTribMunicipal tribMun = infDPS.getValores().getTrib().getTribMun();
        TCExigSuspensa exigSuspensa = tribMun.getExigSusp();
        if (exigSuspensa != null) {
            notafiscal.setProcessoexigibilidadeNfs(exigSuspensa.getNProcesso());
        }
        TributacaoIssqn tribIssqn = TributacaoIssqn.of((String)tribMun.getTribISSQN());
        notafiscal.setExigibilidadeissNfs(NFSeUtil.parseExigibilidade((TributacaoIssqn)tribIssqn, (TCExigSuspensa)exigSuspensa));
        TCInfoValores valoresDps = infDPS.getValores();
        TCTribFederal tribFed = valoresDps.getTrib().getTribFed();
        if (tribFed == null) {
            tribFed = new TCTribFederal();
        }
        notafiscal.setValorcsllNfs(Double.valueOf(NumberUtils.toDouble((String)tribFed.getVRetCSLL())));
        notafiscal.setValorirrfNfs(Double.valueOf(NumberUtils.toDouble((String)tribFed.getVRetIRRF())));
        TCTribOutrosPisCofins piscofins = tribFed.getPiscofins();
        if (piscofins == null) {
            piscofins = new TCTribOutrosPisCofins();
        }
        notafiscal.setBasecalculopisNfs(Double.valueOf(NumberUtils.toDouble((String)piscofins.getVBCPisCofins())));
        notafiscal.setAliquotapisNfs(Double.valueOf(NumberUtils.toDouble((String)piscofins.getPAliqPis())));
        notafiscal.setValorpisNfs(Double.valueOf(NumberUtils.toDouble((String)piscofins.getVPis())));
        if (notafiscal.getValorpisNfs() > 0.0) {
            notafiscal.setIncidePisNfs(SimNao.SIM);
        }
        notafiscal.setBasecalculocofinsNfs(Double.valueOf(NumberUtils.toDouble((String)piscofins.getVBCPisCofins())));
        notafiscal.setAliquotacofinsNfs(Double.valueOf(NumberUtils.toDouble((String)piscofins.getPAliqCofins())));
        notafiscal.setValorcofinsNfs(Double.valueOf(NumberUtils.toDouble((String)piscofins.getVCofins())));
        if (notafiscal.getValorcofinsNfs() > 0.0) {
            notafiscal.setIncideCofinsNfs(SimNao.SIM);
        }
        TCValoresNFSe valoresNFSe = tcnfSe.getInfNFSe().getValores();
        notafiscal.setValorissNfs(Double.valueOf(NumberUtils.toDouble((String)valoresNFSe.getVISSQN())));
        TCTribTotal tottrib = valoresDps.getTrib().getTotTrib();
        TCTribTotalPercent ptottrib = tottrib.getPTotTrib();
        TCTribTotalMonet vtottrib = tottrib.getVTotTrib();
        if (ptottrib != null && vtottrib != null) {
            notafiscal.setValorTributosNfs(String.format(Constants.PT_BR, "Val. Aprox. Tributos: Federal (%.2f%%) R$%.2f Estadual (%.2f%%) R$%.2f Municipal (%.2f%%) R$%.2f", NumberUtils.toDouble((String)ptottrib.getPTotTribFed()), NumberUtils.toDouble((String)vtottrib.getVTotTribFed()), NumberUtils.toDouble((String)ptottrib.getPTotTribEst()), NumberUtils.toDouble((String)vtottrib.getVTotTribEst()), NumberUtils.toDouble((String)ptottrib.getPTotTribMun()), NumberUtils.toDouble((String)vtottrib.getVTotTribMun())));
        }
        notafiscal.getNotaNacional().setTpImunidadeNfn(TipoImunidadeIssqn.of((String)tribMun.getTpImunidade()));
        notafiscal.getNotaNacional().setSitTribPiscofinsNfn(SituacaoTributariaPisCofins.of((String)piscofins.getCST()));
        notafiscal.getNotaNacional().setTpRetPiscofinsNfn(TipoRetencaoPisCofins.of((String)piscofins.getTpRetPisCofins()));
    }

    private void preencherServico(TCNFSe tcnfSe, LiNotafiscalItens item) {
        log.trace("Preenchendo servico {}", (Object)item.getPk());
        TCServ tcServ = tcnfSe.getInfNFSe().getDPS().getInfDPS().getServ();
        TCInfoValores valoresDps = tcnfSe.getInfNFSe().getDPS().getInfDPS().getValores();
        Double aliq = NumberUtils.createDouble((String)tcnfSe.getInfNFSe().getValores().getPAliqAplic());
        double aliquota = aliq != null ? aliq : NumberUtils.toDouble((String)valoresDps.getTrib().getTribMun().getPAliq());
        item.setAliquotaNfi(Double.valueOf(aliquota));
        item.setDeducaobaseNfi(Double.valueOf(valoresDps.getVDedRed() != null ? NumberUtils.toDouble((String)valoresDps.getVDedRed().getVDR()) : 0.0));
        String cTribNac = tcServ.getCServ().getCTribNac();
        LiAtivdesdo liAtivdesdo = this.liAtivdesdoService.findByCodigoTributacao(cTribNac);
        if (liAtivdesdo == null) {
            throw new FiorilliException("Atividade n\u00e3o encontrada para o c\u00f3digo " + cTribNac);
        }
        item.setCodAtvNfi(liAtivdesdo.getPk().getCodAtvAtd());
        item.setCodAtdNfi(liAtivdesdo.getPk().getCodAtd());
        item.setDescatvLc116Nfi(liAtivdesdo.getDescativAtd());
        item.setCodleiLc116Nfi(liAtivdesdo.getCodleiAtd());
        item.setDescriNfi(tcServ.getCServ().getXDescServ());
        TCVDescCondIncond desconto = valoresDps.getVDescCondIncond();
        double descontoCond = desconto != null ? NumberUtils.toDouble((String)desconto.getVDescCond()) : 0.0;
        item.setDesccondicionalNfi(Double.valueOf(descontoCond));
        double descontoIncond = desconto != null ? NumberUtils.toDouble((String)desconto.getVDescIncond()) : 0.0;
        item.setDescincondicionalNfi(Double.valueOf(descontoIncond));
        item.setMedidaNfi("UN");
        item.setQuantidadeNfi(Double.valueOf(1.0));
        item.setValorincentivoNfi(Double.valueOf(0.0));
        item.setValorNfi(Double.valueOf(NumberUtils.toDouble((String)valoresDps.getVServPrest().getVServ())));
        item.setVlrUnitarioNfi(Double.valueOf(NumberUtils.toDouble((String)valoresDps.getVServPrest().getVServ())));
        if (tcServ.getCServ().getCNBS() != null) {
            item.setLiServicoNbs(this.liServicoNbsService.findByCodigo(tcServ.getCServ().getCNBS()));
        }
        NotaFiscalRecebimentoService_v1_00.checkShutdown();
    }

    private void preencherMovimento(TCNFSe tcnfSe, LiNotafiscal liNotafiscal) {
        OrigemMovimento origem;
        NotaFiscalRecebimentoService_v1_00.checkShutdown();
        log.trace("Preencher movimento {}", (Object)liNotafiscal.getAdnNsuNfs());
        OrigemMovimento origemMovimento = origem = SituacaoNfse.of((String)tcnfSe.getInfNFSe().getCStat()) == SituacaoNfse.NFSE_AVULSA ? OrigemMovimento.AVULSA : OrigemMovimento.CONVENCIONAL;
        if (liNotafiscal.getTiponotaNfs() == TipoNota.DEC_PRESTADOR || liNotafiscal.getTiponotaNfs() == TipoNota.PRESTADOR_OUTRO_MUNICIPIO) {
            origem = OrigemMovimento.PRESTADOR_COMPLETA;
        }
        OrigemMovimento constOrigem = origem;
        LiMovimentoeco liMovimentoeco = this.movimentoService.recuperarMovimento(FiorilliUtils.toDateTime((String)tcnfSe.getInfNFSe().getDPS().getInfDPS().getDhEmi()).toLocalDate(), liNotafiscal.getCodModNfs(), liNotafiscal.getCadastroNfs(), liNotafiscal.getCodCntNfs(), constOrigem);
        liNotafiscal.setCodMecNfs(liMovimentoeco.getLiMovimentoecoPK().getCodMec().intValue());
    }

    private void preencherPrestador(TCNFSe tcnfSe, LiNotafiscal liNotafiscal) {
        NotaFiscalRecebimentoService_v1_00.checkShutdown();
        log.trace("Preencher prestador {}", (Object)liNotafiscal.getAdnNsuNfs());
        TCInfNFSe infNFSe = tcnfSe.getInfNFSe();
        TCInfoPrestador prest = infNFSe.getDPS().getInfDPS().getPrest();
        TipoEmitenteDPS tipoEmitente = TipoEmitenteDPS.of((String)infNFSe.getDPS().getInfDPS().getTpEmit());
        if (tipoEmitente != TipoEmitenteDPS.PRESTADOR && prest.getEnd() != null && prest.getEnd().getEndExt() != null) {
            liNotafiscal.getNotaNacional().setProvextPrestNfn(prest.getEnd().getEndExt().getXEstProvReg());
        }
        Supplier<Boolean> preencher = () -> {
            NotaFiscalRecebimentoService_v1_00.checkShutdown();
            log.trace("Preenchimento mobiliario para nota {}", (Object)liNotafiscal.getAdnNsuNfs());
            String documento = tipoEmitente == TipoEmitenteDPS.PRESTADOR ? infNFSe.getEmit().getCNPJ() : prest.getCNPJ();
            Optional optMobil = this.mobiliarioService.recuperarEmpresa(documento);
            if (optMobil.isPresent()) {
                log.debug("Mobiliario found, preenchendo para nota {}", (Object)liNotafiscal.getAdnNsuNfs());
                LiMobil mobil = (LiMobil)optMobil.get();
                liNotafiscal.setCadastroNfs(mobil.getLiMobilPK().getCodMbl());
                liNotafiscal.setCodCntNfs(mobil.getCodCntMbl());
                liNotafiscal.setCodModNfs(2);
                liNotafiscal.setTiponotaNfs(TipoNota.NOTA_CONVENCIONAL);
                liNotafiscal.setTipoissNfs(mobil.getTipoissMbl());
                return true;
            }
            return false;
        };
        try {
            GrContribuintes cont;
            if (!preencher.get().booleanValue()) {
                NotaFiscalRecebimentoService_v1_00.checkShutdown();
                cont = this.contribuinteService.syncContribuinte(prest, infNFSe.getEmit());
                String codigoMunicipio = null;
                if (tipoEmitente == TipoEmitenteDPS.PRESTADOR) {
                    codigoMunicipio = infNFSe.getEmit().getEnderNac().getCMun();
                } else if (prest.getEnd().getEndNac() != null) {
                    codigoMunicipio = prest.getEnd().getEndNac().getCMun();
                }
                boolean podeSalvarMobil = this.utilService.getServicosWebCanSaveMobil();
                if (!this.NFSeRecebimentoService.getCodigoCidade().equals(codigoMunicipio) || !podeSalvarMobil) {
                    log.debug("Sem mobil. Prestador de outro municipio: tipo nota PRESTADOR_OUTRO_MUNICIPIO");
                    liNotafiscal.setCadastroNfs(cont.getGrContribuintesPK().getCodCnt());
                    liNotafiscal.setCodCntNfs(cont.getGrContribuintesPK().getCodCnt());
                    liNotafiscal.setCodModNfs(5);
                    liNotafiscal.setTiponotaNfs(!podeSalvarMobil ? TipoNota.NOTA_CONVENCIONAL : TipoNota.PRESTADOR_OUTRO_MUNICIPIO);
                    this.mobiliarioService.markDontSave(cont.getCnpjCnt());
                    return;
                }
                if (SituacaoNfse.of((String)infNFSe.getCStat()) == SituacaoNfse.NFSE_AVULSA || StringUtils.isBlank((CharSequence)prest.getCNPJ())) {
                    log.trace("Sem mobil. Situacao da nota NFSE_AVULSA. Tipo nota NOTA_AVULSA.");
                    liNotafiscal.setCadastroNfs(cont.getGrContribuintesPK().getCodCnt());
                    liNotafiscal.setCodCntNfs(cont.getGrContribuintesPK().getCodCnt());
                    liNotafiscal.setCodModNfs(5);
                    liNotafiscal.setTiponotaNfs(TipoNota.NOTA_AVULSA);
                    this.mobiliarioService.markDontSave(cont.getCnpjCnt());
                    return;
                }
            } else {
                return;
            }
            NotaFiscalRecebimentoService_v1_00.checkShutdown();
            log.trace("Salvando mobil para cnt {} em nota {}", (Object)cont.getCnpjCnt(), (Object)liNotafiscal.getAdnNsuNfs());
            this.mobiliarioService.saveMobiliarioFromNota(prest, cont);
            if (!preencher.get().booleanValue()) {
                throw new FiorilliException("N\u00e3o foi poss\u00edvel preencher o prestador");
            }
        }
        catch (ConstraintViolationException e) {
            throw new FiorilliException("Erro de valida\u00e7\u00e3o! " + String.valueOf(e.getConstraintViolations()), (Throwable)e);
        }
    }

    private void preencherTomador(LiNotafiscal liNotafiscal, TCInfoPessoa tomador) {
        if (tomador == null) {
            return;
        }
        log.trace("Preencher tomador");
        liNotafiscal.setCpfCnpjNfs(StringUtils.isNotBlank((CharSequence)tomador.getCNPJ()) ? tomador.getCNPJ() : tomador.getCPF());
        liNotafiscal.setNomeRazaosocialNfs(tomador.getXNome());
        liNotafiscal.setEmailNfs(tomador.getEmail());
        String fone = tomador.getFone();
        if (fone != null && fone.length() < 15) {
            liNotafiscal.setFoneNfs(fone);
        }
        liNotafiscal.setInscrmNfs(tomador.getIM());
        if (tomador.getEnd() == null) {
            return;
        }
        log.trace("Preencher tomador endereco");
        TCEnderExt tcEnderExt = tomador.getEnd().getEndExt();
        if (tcEnderExt != null) {
            log.trace("Tomador endereco exterior");
            liNotafiscal.setMunicipioNfs(tcEnderExt.getXCidade());
            liNotafiscal.setEstadoProvinciaNfs(tcEnderExt.getXEstProvReg());
            liNotafiscal.setCdPaistomadorNfs(this.utilService.findCodBceByIso2(tcEnderExt.getCPais()));
            liNotafiscal.setTomadorforapaisNfs(SimNao.SIM);
        } else {
            if (tomador.getNIF() != null) {
                liNotafiscal.setCpfCnpjNfs(tomador.getNIF());
            }
            liNotafiscal.setCepNfs(tomador.getEnd().getEndNac().getCEP());
            liNotafiscal.setCdMunicipiotomadorNfs(Objects.nonNull(tomador.getEnd().getEndNac().getCMun()) ? Integer.valueOf(tomador.getEnd().getEndNac().getCMun()) : null);
            liNotafiscal.setLogradouroNfs(tomador.getEnd().getXLgr());
            liNotafiscal.setNumeroNfs(StringUtils.truncate((String)tomador.getEnd().getNro(), (int)10));
            liNotafiscal.setComplementoNfs(StringUtils.truncate((String)tomador.getEnd().getXCpl(), (int)60));
            liNotafiscal.setBairroNfs(tomador.getEnd().getXBairro());
            liNotafiscal.setCdPaistomadorNfs(Integer.valueOf(1058));
            liNotafiscal.setTomadorforapaisNfs(SimNao.NAO);
        }
    }

    public LiNotafiscal atualizarNotaExistente(NsuObjectHolder<TCNFSe> tcnfSeHolder) {
        return this.liNotafiscalService.findNotaByNsu(tcnfSeHolder.getNsu()).map(nota -> {
            nota = this.processLiNota(tcnfSeHolder, nota);
            this.salvarPreencherDados((TCNFSe)tcnfSeHolder.getObject(), nota);
            return nota;
        }).orElseThrow(() -> {
            log.warn("Nota j\u00e1 existente: {}", (Object)tcnfSeHolder.getNsu());
            return new IllegalStateException("Nota lan\u00e7ou erro no cadastro por j\u00e1 existir, mas n\u00e3o foi encontrada no banco");
        });
    }

    private static void checkShutdown() {
        if (ShutdownHook.shutdownInitiaded.get()) {
            throw new ShutdownSignalException();
        }
    }

    public NotaFiscalRecebimentoService_v1_00(MovimentoService movimentoService, MobiliarioService mobiliarioService, ContribuinteService contribuinteService, UtilService utilService, LiNotafiscalService liNotafiscalService, LiAtivdesdoService liAtivdesdoService, ConfigService configService, LiServicoNbsService liServicoNbsService, NFSeRecebimentoService NFSeRecebimentoService2) {
        this.movimentoService = movimentoService;
        this.mobiliarioService = mobiliarioService;
        this.contribuinteService = contribuinteService;
        this.utilService = utilService;
        this.liNotafiscalService = liNotafiscalService;
        this.liAtivdesdoService = liAtivdesdoService;
        this.configService = configService;
        this.liServicoNbsService = liServicoNbsService;
        this.NFSeRecebimentoService = NFSeRecebimentoService2;
    }
}

