/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.client.AdnClient;
import br.com.fiorilli.nfse_nacional.dto.nfse.ConsultaConvenioResponse;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.model.GrCidade;
import br.com.fiorilli.nfse_nacional.model.Municipio;
import br.com.fiorilli.nfse_nacional.services.data.NfsePersistenceManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class UtilService {
    private static final Logger log = LoggerFactory.getLogger(UtilService.class);
    public static final Charset WIN_1252 = Charset.forName("Windows-1252");
    private final AdnClient adnClient;
    private final NfsePersistenceManager nfsePersistenceManager;
    private final ObjectMapper mapper;

    @PostConstruct
    public void init() {
        Optional salvarMobil = this.buscarConfigSaveMobil();
        if (salvarMobil.isEmpty()) {
            this.nfsePersistenceManager.run(em -> {
                log.debug("Initializar GERAR_INSC_NFSE_CSW");
                em.createNativeQuery("update GR_CONFSERVICOSWEB set GERAR_INSC_NFSE_CSW = 'S'").executeUpdate();
            }, true);
        }
    }

    @Cacheable(cacheNames={"utils-cache-ativosefin"})
    public ConsultaConvenioResponse fetchDadosConvenioMunicipio(Integer codigoMunicipio) {
        try {
            return (ConsultaConvenioResponse)this.adnClient.consultarConvenioMunicipio(codigoMunicipio).getBody();
        }
        catch (FiorilliException e) {
            log.error("Erro na consulta do conv\u00eanio municipal: {}", (Object)e, (Object)e);
            return null;
        }
    }

    @Cacheable(cacheNames={"utils-cache-cansavemobil"})
    public boolean getServicosWebCanSaveMobil() {
        log.trace("Checando configura\u00e7\u00e3o...");
        Optional optRes = this.buscarConfigSaveMobil();
        log.debug("Configura\u00e7\u00e3o: {}", (Object)optRes);
        return optRes.isEmpty() || ((Character)optRes.get()).charValue() == 'S';
    }

    public Optional<Character> buscarConfigSaveMobil() {
        return (Optional)this.nfsePersistenceManager.call(em -> {
            List l = em.createNativeQuery("select GERAR_INSC_NFSE_CSW from GR_CONFSERVICOSWEB").getResultList();
            List list = l;
            if (list.isEmpty()) {
                return Optional.empty();
            }
            return Optional.ofNullable((Character)list.getFirst());
        }, false);
    }

    @Cacheable(cacheNames={"utils-cache-cidade"})
    public GrCidade findCidadeByCdMunicipio(Integer cdMunicipio) {
        log.trace("Recuperando COD_CID para municipio {}...", (Object)cdMunicipio);
        GrCidade res = (GrCidade)this.nfsePersistenceManager.call(em -> {
            log.debug("CALL findCidadeByCdMunicipio");
            List list = em.createQuery("from GrCidade c left join fetch c.municipio m where m.cdMunicipio = ?1", GrCidade.class).setParameter(1, (Object)cdMunicipio).getResultList();
            if (list.isEmpty()) {
                return null;
            }
            return (GrCidade)list.getFirst();
        }, false);
        if (res == null) {
            log.debug("COD_CID nao encontrado para CD_MUNICIPIO = {}", (Object)cdMunicipio);
            return null;
        }
        return res;
    }

    @Cacheable(cacheNames={"utils-cache-codbce"})
    public Integer findCodBceByIso2(String iso2) {
        log.trace("Recuperando codigo do pais {}...", (Object)iso2);
        if (StringUtils.isBlank((CharSequence)iso2)) {
            log.debug("Codigo do pais nulo");
            return null;
        }
        Optional res = (Optional)this.nfsePersistenceManager.call(em -> {
            List l;
            log.debug("CALL findCodBceByIso2");
            List list = l = em.createNativeQuery("select COD_BCE from GR_BACEN where ISO_ALPHA2_BCE = ?1", Integer.class).setParameter(1, (Object)iso2).getResultList();
            if (list.isEmpty()) {
                return Optional.empty();
            }
            return Optional.ofNullable((Integer)list.getFirst());
        }, false);
        if (res.isEmpty()) {
            log.debug("Codigo do pais {} nao encontrado", (Object)iso2);
            return null;
        }
        log.debug("Codigo do pais {} : {}", (Object)iso2, (Object)res);
        return (Integer)res.get();
    }

    @Cacheable(cacheNames={"utils-cache-iso2"})
    public String findIso2ByCodBce(Integer codBce) {
        log.trace("Recuperando ISO do pais {}...", (Object)codBce);
        if (codBce == null) {
            log.debug("cod_bce do pais nulo");
            return null;
        }
        Optional res = (Optional)this.nfsePersistenceManager.call(em -> {
            List l;
            log.debug("CALL findIso2ByCodBce");
            List list = l = em.createNativeQuery("select ISO_ALPHA2_BCE from GR_BACEN where COD_BCE = ?1", String.class).setParameter(1, (Object)codBce).getResultList();
            if (list.isEmpty()) {
                return Optional.empty();
            }
            return Optional.ofNullable((String)list.getFirst());
        }, false);
        if (res.isEmpty()) {
            log.debug("Codigo do pais {} nao encontrado", (Object)codBce);
            return null;
        }
        log.debug("Codigo do pais {} : {}", (Object)codBce, (Object)res);
        return (String)res.get();
    }

    @Cacheable(cacheNames={"utils-cache-municipio"})
    public Municipio findMunicipio(Integer codigoIbge) {
        return (Municipio)this.nfsePersistenceManager.call(em -> {
            log.debug("CALL findCdMunicipioCidadeAtual");
            List list = em.createQuery("select m from Municipio m where m.cdMunicipio = :codIbge ", Municipio.class).setParameter("codIbge", (Object)codigoIbge).getResultList();
            if (list.isEmpty()) {
                return null;
            }
            return (Municipio)list.getFirst();
        }, false);
    }

    @Cacheable(cacheNames={"utils-cache-municipio"})
    public Municipio findMunicipioByGrCidade(String codigoCidade) {
        return (Municipio)this.nfsePersistenceManager.call(em -> {
            List list = em.createQuery("select c from GrCidade c\ninner join c.municipio m\nwhere c.codCid = :codigo\n", GrCidade.class).setParameter("codigo", (Object)codigoCidade).getResultList();
            if (list.isEmpty()) {
                return null;
            }
            return ((GrCidade)list.getFirst()).getMunicipio();
        }, true);
    }

    public String objectToJsonString(Object o) {
        log.trace("Escrevendo objeto como json {}", o);
        String res = this.mapper.writeValueAsString(o);
        log.debug("Resultado em JSON: {}", (Object)res);
        return res;
    }

    public void cleanDbAccess() {
        this.nfsePersistenceManager.clearEMs(false);
    }

    @CacheEvict(value={"utils-cache-ativosefin", "utils-cache-cansavemobil"}, allEntries=true)
    @Scheduled(cron="0 */10 * * * *")
    public void emptyCaches() {
        log.info("Emptying temp caches");
    }

    public UtilService(AdnClient adnClient, NfsePersistenceManager nfsePersistenceManager, ObjectMapper mapper) {
        this.adnClient = adnClient;
        this.nfsePersistenceManager = nfsePersistenceManager;
        this.mapper = mapper;
    }
}

