/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services.data;

import br.com.fiorilli.nfse_nacional.model.GrContribuintes;
import br.com.fiorilli.nfse_nacional.services.data.NfsePersistenceManager;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GrContribuintesService {
    private static final Logger log = LoggerFactory.getLogger(GrContribuintesService.class);
    private final NfsePersistenceManager nfsePersistenceManager;
    private static final ReentrantLock persistLock = new ReentrantLock();

    public List<GrContribuintes> recuperarContribuintes(String documento) {
        return (List)this.nfsePersistenceManager.call(em -> {
            log.debug("CALL recuperarContribuintes {}", (Object)documento);
            return em.createQuery("from GrContribuintes c\nwhere c.grContribuintesPK.codEmpCnt = 1\n    and c.cnpjCnt = :documento\n", GrContribuintes.class).setParameter("documento", (Object)documento).getResultList();
        }, false);
    }

    public Optional<GrContribuintes> findByCodigo(String codigo) {
        return (Optional)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL findByCodigo {}", taskId, (Object)codigo);
            return em.createQuery("from GrContribuintes\nwhere grContribuintesPK.codEmpCnt = 1\nand grContribuintesPK.codCnt = :codigo\n", GrContribuintes.class).setParameter("codigo", (Object)codigo).getResultStream().findFirst();
        }, false);
    }

    public GrContribuintes merge(GrContribuintes entity) {
        return (GrContribuintes)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL merge {}", taskId, (Object)entity.getGrContribuintesPK());
            return (GrContribuintes)em.merge((Object)entity);
        }, true, persistLock);
    }

    public GrContribuintesService(NfsePersistenceManager nfsePersistenceManager) {
        this.nfsePersistenceManager = nfsePersistenceManager;
    }
}

