/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services.data;

import br.com.fiorilli.nfse_nacional.model.LiConfig;
import br.com.fiorilli.nfse_nacional.services.data.NfsePersistenceManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiConfigService {
    private static final Logger log = LoggerFactory.getLogger(LiConfigService.class);
    private final NfsePersistenceManager nfsePersistenceManager;

    public LiConfig find() {
        log.trace("Recuperando LiConfig...");
        return (LiConfig)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL find", taskId);
            List list = em.createQuery("from LiConfig", LiConfig.class).getResultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("LI_CONFIG vazio!");
            }
            return (LiConfig)list.getFirst();
        }, false);
    }

    public LiConfig merge(LiConfig liConfig) {
        return (LiConfig)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL merge {}", taskId, (Object)liConfig);
            return (LiConfig)em.merge((Object)liConfig);
        }, false);
    }

    public Integer cadastrarSerieNacional() {
        List res = (List)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL cadastrarSerieNacional", taskId);
            em.createNativeQuery("insert into li_serienf(cod_emp_snf, cod_snf, serie_snf, login_inc_snf, dta_inc_snf)\nvalues (1, (select max(cod_snf) + 1 from li_serienf), 'NFSe Nacional', ?1, current_timestamp)\n").setParameter(1, (Object)"nfse-nac").executeUpdate();
            return em.createNativeQuery("select cod_snf from li_serienf where serie_snf = 'NFSe Nacional' and login_inc_snf = ?1\n").setParameter(1, (Object)"nfse-nac").getResultList();
        }, true);
        if (res.isEmpty()) {
            log.error("\n\n\n################################################################################################\n ERRO: Houve falha na inser\u00e7\u00e3o autom\u00e1tica da s\u00e9rie padr\u00e3o nacional. Verifique o banco de dados.\n Contate o suporte para verificar erros e realizar a inser\u00e7\u00e3o da s\u00e9rie padr\u00e3o.\n################################################################################################\n\n");
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel salvar a s\u00e9rie da numera\u00e7\u00e3o nacional");
        }
        return (Integer)res.getFirst();
    }

    public LiConfigService(NfsePersistenceManager nfsePersistenceManager) {
        this.nfsePersistenceManager = nfsePersistenceManager;
    }
}

