/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services.data;

import br.com.fiorilli.nfse_nacional.model.LiNfseEnvioQueue;
import br.com.fiorilli.nfse_nacional.model.enums.StatusNfseQueue;
import br.com.fiorilli.nfse_nacional.services.data.NfsePersistenceManager;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiNfseEnvioQueueService {
    private static final Logger log = LoggerFactory.getLogger(LiNfseEnvioQueueService.class);
    private final NfsePersistenceManager nfsePersistenceManager;

    public List<LiNfseEnvioQueue> queryFirstEnvios(int n) {
        return (List)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: call queryFirstEnvios", taskId);
            return em.createQuery("from LiNfseEnvioQueue where statusNeq = :status order by dtaIncNeq asc", LiNfseEnvioQueue.class).setParameter("status", (Object)StatusNfseQueue.NAO_ENVIADO).setMaxResults(n).getResultStream().peek(envio -> {
                if (envio.getLiNotafiscal() != null) {
                    envio.getLiNotafiscal().getLiNotafiscalNacional().isEmpty();
                    if (envio.getLiNotafiscal().getCancelamento() != null) {
                        envio.getLiNotafiscal().getCancelamento().getSubstituta();
                    }
                }
            }).collect(Collectors.toList());
        }, true);
    }

    public void batchSave(List<LiNfseEnvioQueue> envios) {
        this.nfsePersistenceManager.run((em, taskId) -> {
            log.debug("Task {}: batchSave", taskId);
            for (LiNfseEnvioQueue envio : envios) {
                if (envio.getStatusNeq() == null) {
                    LiNfseEnvioQueue managedEnvio = em.contains((Object)envio) ? envio : (LiNfseEnvioQueue)em.merge((Object)envio);
                    em.remove((Object)managedEnvio);
                    continue;
                }
                em.merge((Object)envio);
            }
        }, true);
    }

    public LiNfseEnvioQueueService(NfsePersistenceManager nfsePersistenceManager) {
        this.nfsePersistenceManager = nfsePersistenceManager;
    }
}

