/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services.data;

import br.com.fiorilli.nfse_nacional.model.LiNotafiscal;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalNacional;
import br.com.fiorilli.nfse_nacional.services.FirebirdService;
import br.com.fiorilli.nfse_nacional.services.data.NfsePersistenceManager;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiNotafiscalService {
    private static final Logger log = LoggerFactory.getLogger(LiNotafiscalService.class);
    private final NfsePersistenceManager nfsePersistenceManager;
    private final FirebirdService firebirdService;

    public List<Long> nsusCadastrados(List<Long> nsus) {
        return (List)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL nsusCadastrados {}", taskId, (Object)nsus);
            return em.createQuery("select l.adnNsuNfs from LiNotafiscal l\nwhere l.pk.codEmpNfs = 1 and l.adnNsuNfs in :nsus\n", Long.class).setParameter("nsus", (Object)nsus).getResultList();
        }, false);
    }

    public List<LiNotafiscal> notasCadastradasPorCodseguranca(List<String> chaves) {
        return (List)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL notasCadastradasPorCodseguranca {}", taskId, (Object)chaves);
            return em.createQuery("from LiNotafiscal l\nwhere l.pk.codEmpNfs = 1 and l.codsegurancaNfs in :chaves\n", LiNotafiscal.class).setParameter("chaves", (Object)chaves).getResultStream().peek(nota -> {
                nota.getLiNotafiscalItens().isEmpty();
                if (nota.getLiNotaintermediario() != null) {
                    nota.getLiNotaintermediario().isEmpty();
                }
                nota.getLiNotafiscalNacional().isEmpty();
            }).peek(nota -> {
                log.debug("Detaching nota: {}", (Object)nota.getPk());
                em.detach(nota);
            }).collect(Collectors.toList());
        }, true);
    }

    public Optional<LiNotafiscal> findNotaByChave(String chaveNota) {
        return (Optional)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL findNotaByChave {}", taskId, (Object)chaveNota);
            Optional nota = em.createQuery("from LiNotafiscal l\nwhere l.pk.codEmpNfs = 1 and l.codsegurancaNfs = :chave\n", LiNotafiscal.class).setParameter("chave", (Object)chaveNota).getResultList().stream().findFirst();
            if (nota.isPresent()) {
                if (((LiNotafiscal)nota.get()).getLiNotaintermediario() != null) {
                    ((LiNotafiscal)nota.get()).getLiNotaintermediario().isEmpty();
                }
                ((LiNotafiscal)nota.get()).getLiNotafiscalItens().isEmpty();
                ((LiNotafiscal)nota.get()).getLiNotafiscalNacional().isEmpty();
            }
            return nota;
        }, true);
    }

    public Optional<Integer> findCodNfsByChave(String chaveNota) {
        return (Optional)this.nfsePersistenceManager.call(em -> {
            log.debug("CALL findCodNfsByChave {}", (Object)chaveNota);
            return em.createQuery("select l.pk.codNfs from LiNotafiscal l\nwhere l.pk.codEmpNfs = 1\n    and l.codsegurancaNfs = :chave\n", Integer.class).setParameter("chave", (Object)chaveNota).getResultList().stream().findFirst();
        }, false);
    }

    public Optional<LiNotafiscal> findNotaByNsu(Long nsu) {
        return (Optional)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL findNotaByNsu {}", taskId, (Object)nsu);
            Optional nota = em.createQuery("select l from LiNotafiscal l\nwhere l.pk.codEmpNfs= 1 and l.adnNsuNfs = :nsu\n", LiNotafiscal.class).setParameter("nsu", (Object)nsu).getResultList().stream().findFirst();
            if (nota.isPresent()) {
                if (((LiNotafiscal)nota.get()).getLiNotaintermediario() != null) {
                    ((LiNotafiscal)nota.get()).getLiNotaintermediario().isEmpty();
                }
                ((LiNotafiscal)nota.get()).getLiNotafiscalItens().isEmpty();
                ((LiNotafiscal)nota.get()).getLiNotafiscalNacional().isEmpty();
            }
            return nota;
        }, true);
    }

    public Optional<LiNotafiscal> findNota(Integer codigo) {
        return (Optional)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL findNota {}", taskId, (Object)codigo);
            Optional nota = em.createQuery("from LiNotafiscal l\nwhere l.pk.codEmpNfs= 1 and l.pk.codNfs = :codigo\n", LiNotafiscal.class).setParameter("codigo", (Object)codigo).getResultStream().findFirst();
            if (nota.isPresent()) {
                if (((LiNotafiscal)nota.get()).getLiNotaintermediario() != null) {
                    ((LiNotafiscal)nota.get()).getLiNotaintermediario().isEmpty();
                }
                ((LiNotafiscal)nota.get()).getLiNotafiscalItens().isEmpty();
                ((LiNotafiscal)nota.get()).getLiNotafiscalNacional().isEmpty();
            }
            return nota;
        }, true);
    }

    public void refreshNota(LiNotafiscal liNotafiscal) {
        this.nfsePersistenceManager.run((em, taskId) -> {
            if (liNotafiscal.getPk() != null && liNotafiscal.getPk().getCodNfs() != null) {
                em.merge((Object)liNotafiscal);
            }
            liNotafiscal.getLiNotafiscalItens().isEmpty();
            if (liNotafiscal.getLiNotaintermediario() != null) {
                liNotafiscal.getLiNotaintermediario().isEmpty();
            }
            liNotafiscal.getLiNotafiscalNacional().isEmpty();
        }, true);
    }

    public LiNotafiscal save(LiNotafiscal liNotafiscal) {
        if (liNotafiscal.getPk().getCodNfs() != null) {
            return this.merge(liNotafiscal);
        }
        return this.persist(liNotafiscal);
    }

    public LiNotafiscal persist(LiNotafiscal liNotafiscal) {
        this.nfsePersistenceManager.run((em, taskId) -> {
            log.debug("Task {}: RUN persist", taskId);
            liNotafiscal.getPk().setCodNfs(Integer.valueOf(this.firebirdService.genId(FirebirdService.Generators.GEN_LI_NOTAFISCAL).intValue()));
            em.persist((Object)liNotafiscal);
        }, true);
        return liNotafiscal;
    }

    public LiNotafiscal merge(LiNotafiscal liNotafiscal) {
        return (LiNotafiscal)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: RUN merge {}", taskId, (Object)liNotafiscal.getPk());
            return (LiNotafiscal)em.merge((Object)liNotafiscal);
        }, true);
    }

    public void delete(LiNotafiscal liNotafiscal) {
        this.nfsePersistenceManager.run((em, taskId) -> {
            log.debug("Task {}: RUN delete {}", taskId, (Object)liNotafiscal.getPk());
            em.remove(em.find(LiNotafiscal.class, (Object)liNotafiscal.getPk()));
        }, true);
    }

    public LiNotafiscalNacional save(LiNotafiscalNacional liNotafiscalNacional) {
        this.nfsePersistenceManager.run((em, taskId) -> {
            log.debug("Task {}: RUN persist", taskId);
            em.persist((Object)liNotafiscalNacional);
        }, true);
        return liNotafiscalNacional;
    }

    public LiNotafiscalService(NfsePersistenceManager nfsePersistenceManager, FirebirdService firebirdService) {
        this.nfsePersistenceManager = nfsePersistenceManager;
        this.firebirdService = firebirdService;
    }
}

