/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class FiorilliUtils {
    public static final int CODIGO_BRASIL = 1058;

    public static String cifrarDecifrar(String texto) {
        if (texto != null) {
            char[] senhaCrypt = new char[texto.length()];
            for (int cont = texto.trim().length(); cont >= 1; --cont) {
                char codAsc = texto.charAt(cont - 1);
                int i = codAsc ^ 4;
                senhaCrypt[texto.length() - cont] = (char)i;
            }
            return new String(senhaCrypt);
        }
        return "";
    }

    public static <T> List<T> listSingle(T t) {
        return new ArrayList<T>(List.of(t));
    }

    public static <T> boolean iterableContainsSuch(Iterable<T> iterable, Predicate<T> predicate) {
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static LocalDateTime toDateTime(String value) {
        return LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
    }

    public static LocalDate toDate(String value) {
        return LocalDate.parse(value, DateTimeFormatter.ISO_DATE);
    }

    public static String calcularDV(String chave) {
        int soma = 0;
        int peso = 2;
        for (int i = chave.length() - 1; i >= 0; --i) {
            int digito = Integer.parseInt(String.valueOf(chave.charAt(i)));
            soma += digito * peso;
            peso = peso == 9 ? 2 : peso + 1;
        }
        int resto = soma % 11;
        int dv = resto == 0 || resto == 1 ? 0 : 11 - resto;
        return String.valueOf(dv);
    }

    private FiorilliUtils() {
    }
}

