/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.utils;

import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscal;
import br.com.fiorilli.nfse_nacional.model.enums.ExigibilidadeISS;
import br.com.fiorilli.nfse_nacional.model.enums.RegimeEspecialTributacao;
import br.com.fiorilli.nfse_nacional.model.enums.TributacaoIssqn;
import br.com.fiorilli.nfse_nacional.schema.enums.RegimeEspecialTributacaoNacional;
import br.com.fiorilli.nfse_nacional.schema.enums.SituacaoSimplesNacional;
import br.com.fiorilli.nfse_nacional.schema.enums.TipoEmitenteDPS;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCInfNFSe;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCRegTrib;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCExigSuspensa;
import br.com.fiorilli.nfse_nacional.utils.NFSeUtil;

public final class NFSeUtil {
    private NFSeUtil() {
    }

    public static RegimeEspecialTributacao regimeNacionalParaNosso(TCInfNFSe infNFSe) {
        TCRegTrib regTrib = infNFSe.getDPS().getInfDPS().getPrest().getRegTrib();
        SituacaoSimplesNacional situacaoSimples = SituacaoSimplesNacional.of((String)regTrib.getOpSimpNac());
        if (situacaoSimples == SituacaoSimplesNacional.OPTANTE_MEI) {
            return RegimeEspecialTributacao.MEI;
        }
        if (situacaoSimples == SituacaoSimplesNacional.OPTANTE_MEEPP) {
            return RegimeEspecialTributacao.MEEPP;
        }
        return switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$schema$enums$RegimeEspecialTributacaoNacional[RegimeEspecialTributacaoNacional.of((String)regTrib.getRegEspTrib()).ordinal()]) {
            case 1 -> RegimeEspecialTributacao.COOPERATIVA;
            case 2 -> RegimeEspecialTributacao.ESTIMATIVA;
            case 3 -> RegimeEspecialTributacao.MICROEMPRESAMUNICIPAL;
            case 4 -> RegimeEspecialTributacao.SOCIEDADEPROFISSIONAIS;
            default -> RegimeEspecialTributacao.NAOPOSSUI;
        };
    }

    public static RegimeEspecialTributacao regimeNacionalParaNosso(br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCInfNFSe infNFSe) {
        br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCRegTrib regTrib = infNFSe.getDPS().getInfDPS().getPrest().getRegTrib();
        SituacaoSimplesNacional situacaoSimples = SituacaoSimplesNacional.of((String)regTrib.getOpSimpNac());
        if (situacaoSimples == SituacaoSimplesNacional.OPTANTE_MEI) {
            return RegimeEspecialTributacao.MEI;
        }
        if (situacaoSimples == SituacaoSimplesNacional.OPTANTE_MEEPP) {
            return RegimeEspecialTributacao.MEEPP;
        }
        return switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$schema$enums$RegimeEspecialTributacaoNacional[RegimeEspecialTributacaoNacional.of((String)regTrib.getRegEspTrib()).ordinal()]) {
            case 1 -> RegimeEspecialTributacao.COOPERATIVA;
            case 2 -> RegimeEspecialTributacao.ESTIMATIVA;
            case 3 -> RegimeEspecialTributacao.MICROEMPRESAMUNICIPAL;
            case 4 -> RegimeEspecialTributacao.SOCIEDADEPROFISSIONAIS;
            default -> RegimeEspecialTributacao.NAOPOSSUI;
        };
    }

    public static ExigibilidadeISS parseExigibilidade(TributacaoIssqn tribIssqn, br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCExigSuspensa exigSuspensa) {
        if (exigSuspensa != null) {
            return switch (exigSuspensa.getTpSusp()) {
                case "1" -> ExigibilidadeISS.EXIBILIDADESUSPENSADJ;
                case "2" -> ExigibilidadeISS.EXIBILIDADESUSPENSAPA;
                default -> throw new FiorilliException("Valor inesperado do tipo de suspens\u00e3o da exigibilidade: " + exigSuspensa.getTpSusp());
            };
        }
        return switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$model$enums$TributacaoIssqn[tribIssqn.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> ExigibilidadeISS.EXIGIVEL;
            case 2 -> ExigibilidadeISS.IMUNIDADE;
            case 3 -> ExigibilidadeISS.EXPORTACAO;
            case 4 -> ExigibilidadeISS.NAOINCIDENCIA;
        };
    }

    public static ExigibilidadeISS parseExigibilidade(TributacaoIssqn tribIssqn, TCExigSuspensa exigSuspensa) {
        if (exigSuspensa != null) {
            return switch (exigSuspensa.getTpSusp()) {
                case "1" -> ExigibilidadeISS.EXIBILIDADESUSPENSADJ;
                case "2" -> ExigibilidadeISS.EXIBILIDADESUSPENSAPA;
                default -> throw new FiorilliException("Valor inesperado do tipo de suspens\u00e3o da exigibilidade: " + exigSuspensa.getTpSusp());
            };
        }
        return switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$model$enums$TributacaoIssqn[tribIssqn.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> ExigibilidadeISS.EXIGIVEL;
            case 2 -> ExigibilidadeISS.IMUNIDADE;
            case 3 -> ExigibilidadeISS.EXPORTACAO;
            case 4 -> ExigibilidadeISS.NAOINCIDENCIA;
        };
    }

    public static RegimeEspecialTributacaoNacional regimeNossoParaNacional(RegimeEspecialTributacao reg) {
        return switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$model$enums$RegimeEspecialTributacao[reg.ordinal()]) {
            case 1 -> RegimeEspecialTributacaoNacional.MICROEMPRESA_MUNICIPAL;
            case 2 -> RegimeEspecialTributacaoNacional.ESTIMATIVA;
            case 3 -> RegimeEspecialTributacaoNacional.SOCIEDADE_PROFISSIONAIS;
            case 4 -> RegimeEspecialTributacaoNacional.COOPERATIVA;
            default -> RegimeEspecialTributacaoNacional.NENHUM;
        };
    }

    public static TipoEmitenteDPS parseTipoEmitente(LiNotafiscal nota) {
        return switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$model$enums$TipoNota[nota.getTiponotaNfs().ordinal()]) {
            case 1, 2, 3 -> TipoEmitenteDPS.PRESTADOR;
            case 4 -> {
                switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$model$enums$ResponsavelRetencao[nota.getResponsavelretencaoNfs().ordinal()]) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield TipoEmitenteDPS.TOMADOR;
                    }
                    case 2: 
                }
                yield TipoEmitenteDPS.INTERMEDIARIO;
            }
            default -> throw new IllegalArgumentException("Imposs\u00edvel deduzir tipo emitente do tipo da nota");
        };
    }
}

