/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlUtils {
    public static <T> String xmlToString(T source, Marshaller marshaller) {
        StringResult result = new StringResult();
        marshaller.marshal(source, (Result)result);
        String xml = result.toString();
        return XmlUtils.replaces((String)xml);
    }

    public static <T> T stringToXml(String source, Unmarshaller unmarshaller) {
        try {
            return (T)unmarshaller.unmarshal((Source)new StringSource(source));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String replaces(String xml) {
        return xml.replace("<!\\[CDATA\\[<!\\[CDATA\\[", "<!\\[CDATA\\[").replace("\\]\\]>\\]\\]>", "\\]\\]>").replace("ns2:", "").replace("ns3:", "").replace("&lt;", "<").replace("&gt;", ">").replace("<Signature>", "<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">").replace(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "").replace("xmlns:ns3=\"http://www.sped.fazenda.gov.br/nfse\"", "xmlns=\"http://www.sped.fazenda.gov.br/nfse\"").replace(" xmlns=\"\" xmlns:ns3=\"http://www.portalfiscal.inf.br/nfe\"", "").replace("<NFe>", "<NFe xmlns=\"http://www.portalfiscal.inf.br/nfe\">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sign(byte[] xml, byte[] pkcs12, char[] password) throws Exception {
        String C14NEXC = "http://www.w3.org/2001/10/xml-exc-c14n#";
        ByteArrayInputStream sourceXml = new ByteArrayInputStream(xml);
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try (ByteArrayInputStream bais = new ByteArrayInputStream(pkcs12);){
                keyStore.load(bais, password);
            }
            XMLSignatureFactory xmlFactory = XMLSignatureFactory.getInstance("DOM");
            Reference reference = XmlUtils.createReference((XMLSignatureFactory)xmlFactory, (String)C14NEXC);
            SignedInfo signedInfo = XmlUtils.createSignedInfo((XMLSignatureFactory)xmlFactory, (Reference)reference);
            KeyInfo keyInfo = XmlUtils.createKeyInfo((XMLSignatureFactory)xmlFactory, (X509Certificate)XmlUtils.getFirstCertificate((KeyStore)keyStore));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(sourceXml);
            Key key = XmlUtils.getFirstKey((KeyStore)keyStore, (char[])password);
            if (key == null) {
                throw new RuntimeException("Private Key not found");
            }
            DOMSignContext dsc = new DOMSignContext(key, (Node)doc.getDocumentElement());
            XMLSignature signature = xmlFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(dsc);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(output));
            String string = output.toString();
            return string;
        }
        finally {
            if (Collections.singletonList(sourceXml).get(0) != null) {
                ((InputStream)sourceXml).close();
            }
        }
    }

    private static KeyInfo createKeyInfo(XMLSignatureFactory factory, X509Certificate certificate) {
        KeyInfoFactory keyInfoFactory = factory.getKeyInfoFactory();
        X509Data newX509Data = keyInfoFactory.newX509Data(Arrays.asList(certificate));
        List<X509Data> data = Arrays.asList(newX509Data);
        return keyInfoFactory.newKeyInfo(data);
    }

    private static SignedInfo createSignedInfo(XMLSignatureFactory factory, Reference reference) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CanonicalizationMethod canonicalizationMethod = factory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        SignatureMethod signatureMethod = factory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        return factory.newSignedInfo(canonicalizationMethod, signatureMethod, Collections.singletonList(reference));
    }

    private static Reference createReference(XMLSignatureFactory factory, String C14NEXC) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        List<Transform> transforms = Arrays.asList(factory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null), factory.newTransform(C14NEXC, (TransformParameterSpec)null));
        DigestMethod digestMethod = factory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        return factory.newReference("", digestMethod, transforms, null, null);
    }

    public static X509Certificate getFirstCertificate(KeyStore keystore) throws Exception {
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = keystore.getCertificate(alias);
            if (!(cert instanceof X509Certificate)) continue;
            return (X509Certificate)cert;
        }
        throw new CertificateException("No certificate found");
    }

    public static Key getFirstKey(KeyStore keystore, char[] password) throws Exception {
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Key cert = keystore.getKey(alias, password);
            if (!(cert instanceof RSAPrivateCrtKey)) continue;
            return cert;
        }
        return null;
    }

    public static String descobrirVersaoXml(String xml) {
        Matcher matcher = Pattern.compile("<(?:NFSe|evento)[^>]+versao=\"(1\\.\\d{2})\"[^>]*>").matcher(xml);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

