/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business;

import br.com.fiorilli.instalador.business.ConfiguraVirtualHostXmlApplication;
import br.com.fiorilli.instalador.business.ConfiguraVirtualHostXmlIntf;
import br.com.fiorilli.instalador.business.ConfiguraVirtualHostXmlJBossWeb;
import br.com.fiorilli.instalador.model.Params;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class ConfiguraVirtualHost {
    public void configuraModulo(File file, Params params) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.scanZip(file, params.getVirtualHost());
        List<String> files = this.extractWars(file);
        for (String f : files) {
            File warFile = new File(f);
            this.scanZip(warFile, params.getVirtualHost());
            String jarPath = params.getJdkDir().concat(File.separator).concat("bin").concat(File.separator);
            String cmd = String.format("%sjar uf %s %s", jarPath, file.getAbsolutePath(), warFile.getName());
            Process process = Runtime.getRuntime().exec(cmd);
            String error = IOUtils.toString(process.getErrorStream());
            if (StringUtils.isNotBlank(error)) {
                throw new IOException("Ocorreu um erro ao atualizar o pacote ear\n" + error);
            }
            process.destroy();
            if (warFile.delete()) continue;
            warFile.deleteOnExit();
        }
    }

    private void scanZip(File file, String virtualHostName) throws ZipException, IOException, ParserConfigurationException, SAXException, TransformerException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:" + file.toPath().toUri());
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (ZipFile zip = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.getName().contains("application.xml")) {
                        this.configura(fs.getPath(entry.getName(), new String[0]), new ConfiguraVirtualHostXmlApplication());
                        continue;
                    }
                    if (!entry.getName().contains("jboss-web.xml")) continue;
                    this.configura(fs.getPath(entry.getName(), new String[0]), new ConfiguraVirtualHostXmlJBossWeb(virtualHostName));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void configura(Path xmlfilepath, ConfiguraVirtualHostXmlIntf configurador) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        File xmltempfile = File.createTempFile(this.getClass().getCanonicalName(), ".xml");
        Files.copy(xmlfilepath, xmltempfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        configurador.configuraXml(xmltempfile);
        Files.copy(xmltempfile.toPath(), xmlfilepath, StandardCopyOption.REPLACE_EXISTING);
        xmltempfile.deleteOnExit();
    }

    private List<String> extractWars(File file) throws ZipException, IOException, ParserConfigurationException, SAXException, TransformerException {
        ArrayList<String> warNames = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().contains(".war")) continue;
                File tempWar = new File(entry.getName());
                FileOutputStream tempOutWar = new FileOutputStream(tempWar);
                IOUtils.copy(zip.getInputStream(entry), (OutputStream)tempOutWar);
                tempOutWar.close();
                warNames.add(entry.getName());
                tempWar.deleteOnExit();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return warNames;
    }
}

