/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business;

import br.com.fiorilli.instalador.model.Modulo;
import br.com.fiorilli.instalador.model.Params;
import br.com.fiorilli.instalador.util.cli.JBossCli;
import br.com.fiorilli.instalador.vo.DeployVO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;

public class DeployService {
    static Logger logger = Logger.getLogger(DeployService.class);

    private List<DeployVO> recuperarDeployments(Params params) throws Exception {
        List<DeployVO> deployList;
        Throwable throwable = null;
        Object var4_4 = null;
        try (JBossCli jBossCli = new JBossCli(params.getJbossIp(), params.getJbossPort());){
            deployList = jBossCli.getDeployments();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return deployList;
    }

    public void verificarVersoes(Params params, List<Modulo> modulos) throws Exception {
        if (params.isDebug()) {
            logger.info("Listando M\u00f3dulos Instalados em " + params.getJbossIp());
        }
        URI uri = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (JBossCli jBossCli = new JBossCli(params.getJbossIp(), params.getJbossPort());){
            uri = jBossCli.getWebUri();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        List<DeployVO> deployments = this.recuperarDeployments(params);
        for (DeployVO deploy : deployments) {
            for (Modulo modulo : modulos) {
                if (!deploy.getContexts().contains(modulo.getContexto())) continue;
                if (params.isDebug()) {
                    logger.info("Verificando " + modulo.getNome());
                }
                modulo.setVersaoInstalada(this.recuperarVersao(uri, modulo.getContexto()));
                if (!params.isDebug()) continue;
                logger.info(String.valueOf(modulo.getNome()) + " instalado " + modulo.getVersaoInstalada());
            }
        }
    }

    private String recuperarVersao(URI uri, String contexto) throws IOException {
        URL url = new URL("http://" + uri.getHost() + ":" + uri.getPort() + contexto + "/versao");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (conn.getResponseCode() == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            return br.readLine();
        }
        return null;
    }
}

