/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business;

import br.com.fiorilli.instalador.business.InstaladorProgress;
import br.com.fiorilli.instalador.business.InstallJBossLinux;
import br.com.fiorilli.instalador.business.SetupJbossDomainMode;
import br.com.fiorilli.instalador.model.Params;
import br.com.fiorilli.instalador.util.cli.CliException;
import br.com.fiorilli.instalador.util.cli.JBossCli;
import br.com.fiorilli.instalador.util.file.FileUtil;
import br.com.fiorilli.instalador.util.http.FileDownloader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;

public class InstallJBossService {
    private static final String JDK_LINUX32_FILENAME = "jdk-linux-32.zip";
    private static final String JDK_LINUX64_FILENAME = "jdk-linux-x64.zip";
    private static final String JDK_WIN32_FILENAME = "jdk-win-32.zip";
    private static final String JDK_WIN64_FILENAME = "jdk-win-64.zip";
    private static final String JBOSS_FILENAME = "jboss.zip";
    private static final String JBOSS_DIR = "jboss-as-7.1.1.Final";
    private final Logger logger = Logger.getLogger(InstallJBossService.class);
    private final Params params;
    private final InstaladorProgress progress;

    public InstallJBossService(Params params, InstaladorProgress progress) {
        this.params = params;
        this.progress = progress;
    }

    public void install() throws IOException {
        String filename = JBOSS_FILENAME;
        this.logger.info("Baixando JBoss");
        this.download(filename, this.progress);
        this.logger.info("Download File: " + filename);
        File installationPathFile = new File(this.params.getJbossDir().concat(File.separator).concat(JBOSS_DIR));
        this.logger.info("Verificando diretorio antes de extrair: " + installationPathFile.toPath().toString());
        if (!installationPathFile.exists()) {
            this.extractZip(new File(filename), this.params.getJbossDir(), this.progress);
        }
        filename = this.getJDKFilenameToDownload();
        this.logger.info("Baixando Java");
        this.download(filename, this.progress);
        this.logger.info("Download File: " + filename);
        this.extractZip(new File(filename), this.getJDKInstallationPath(), this.progress);
        if (this.params.getJbossMode().equals((Object)Params.JBossMode.DOMAIN)) {
            new SetupJbossDomainMode(this.params, JBOSS_DIR).setup();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            this.installWindows();
            this.logger.info("JBoss Instalado com Sucesso");
        } else {
            this.installLinux();
            this.logger.info("Instalacao Concluida");
            this.logger.warn("Realize as operacoes necessarias para a inicializacao automatica do JBoss no Sistema Operacional");
            this.helpUnixUser();
        }
    }

    private String getJDKInstallationPath() {
        return this.params.getJbossDir().concat(File.separator).concat(JBOSS_DIR).concat(File.separator).concat("jdk");
    }

    private void installLinux() throws IOException {
        if (!Params.getDefaultJBossDir().equals(this.params.getJbossDir())) {
            InstallJBossLinux linuxInstall = new InstallJBossLinux();
            this.logger.info("Atualizando Script de Inicializa\u00e7\u00e3o com Novo Diret\u00f3rio");
            linuxInstall.updateLinuxServiceScript(new File(String.valueOf(this.params.getJbossDir()) + "/" + JBOSS_DIR + "/bin/init.d/jboss-as-standalone.sh"), String.valueOf(this.params.getJbossDir()) + "/" + JBOSS_DIR);
            this.logger.info("Atualizando Script do JBoss-cli com Novo Diret\u00f3rio");
            linuxInstall.updateLinuxCliScript(new File(String.valueOf(this.params.getJbossDir()) + "/" + JBOSS_DIR + "/bin/jboss-cli.sh"), String.valueOf(this.params.getJbossDir()) + "/" + JBOSS_DIR + "/jdk/bin/java");
        }
    }

    public void helpUnixUser() {
        this.logger.info("\n<<< PR\u00d3XIMOS PASSOS >>>:\n");
        this.logger.info("#adduser jboss\n#chown -fR jboss:jboss " + this.params.getJbossDir() + "/" + JBOSS_DIR + "/\n" + "#su jboss\n" + "#chmod -R +x " + this.params.getJbossDir() + "/" + JBOSS_DIR + "/bin\n" + "#chmod -R +x " + this.params.getJbossDir() + "/" + JBOSS_DIR + "/jdk\n" + "\n" + "Inicializacao Automatica\n" + "Debian-like distribution (ex:Ubuntu)\n" + "\t#cp " + this.params.getJbossDir() + "/" + JBOSS_DIR + "/bin/init.d/jboss-as-7-standalone  /etc/init.d/\n" + "\t#update-rc.d jboss-as defaults\n" + "\n" + "RHEL-like distribution (ex:CentOS)\n" + "\t#ln -s -T " + this.params.getJbossDir() + "/" + JBOSS_DIR + "/bin/init.d/jboss-as-standalone.sh /etc/init.d/jboss-as\n" + "\t#chkconfig --add jboss-as --level 0356\n" + "\n" + "Se necessario execute o comando abaixo para listar as portas ocupadas.\n" + "#sudo netstat -tulpn\n" + "\n" + "Verifique como exibir estes itens novamente no help desta aplica\u00e7\u00e3o");
    }

    private void installWindows() {
        try {
            this.logger.info("Registrando Servico no Windows");
            String binpath = String.valueOf(this.params.getJbossDir()) + File.separator + JBOSS_DIR + File.separator + "bin";
            String cmd = String.valueOf(binpath) + File.separator + "service.bat install";
            File dir = new File(binpath);
            Runtime.getRuntime().exec(cmd, null, dir);
            this.logger.info("Iniciando JBoss");
            cmd = String.valueOf(binpath) + File.separator + "service.bat start";
            Runtime.getRuntime().exec(cmd, null, dir);
            Thread.sleep(10000L);
            if (this.params.getJbossMode().equals((Object)Params.JBossMode.STANDALONE)) {
                this.logger.info("Testando JBoss");
                this.testJBossInstallation();
                this.logger.info("JBoss Testado");
            }
        }
        catch (CliException | IOException | InterruptedException e) {
            this.logger.error(e);
            throw new RuntimeException(e);
        }
    }

    public void testJBossInstallation() throws CliException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (JBossCli cli = new JBossCli(this.params.getJbossIp(), this.params.getJbossPort());){
            String serverState = cli.getServerState();
            this.logger.debug(serverState);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void extractZip(File theFile, String installationPath, InstaladorProgress progress) {
        try {
            this.logger.info("Extraindo em: " + installationPath);
            FileUtil.UnzipArchive(theFile, new File(installationPath), progress);
            this.logger.info("\nArquivos Extraidos com Sucesso");
        }
        catch (IOException e) {
            this.logger.error(e);
            throw new RuntimeException(e);
        }
    }

    private void download(String filename, InstaladorProgress progress) {
        try {
            FileDownloader.downloadFile(new URL("http://www.fiorilli.com.br/instalador/" + filename), filename, progress);
            this.logger.info("\nArquivo baixado com sucesso");
        }
        catch (Exception e) {
            this.logger.error("N\u00e3o foi poss\u00edvel baixar o Arquivo");
            throw new RuntimeException(e);
        }
    }

    private String getJDKFilenameToDownload() {
        if (SystemUtils.IS_OS_WINDOWS) {
            if (this.isWin64()) {
                return JDK_WIN64_FILENAME;
            }
            return JDK_WIN32_FILENAME;
        }
        if (SystemUtils.OS_ARCH != null && SystemUtils.OS_ARCH.indexOf("64") > -1) {
            return JDK_LINUX64_FILENAME;
        }
        return JDK_LINUX32_FILENAME;
    }

    private boolean isWin64() {
        if (System.getProperty("os.name").contains("Windows")) {
            return System.getenv("ProgramFiles(x86)") != null;
        }
        return System.getProperty("os.arch").indexOf("64") > -1;
    }

    public static String getDirName() {
        return JBOSS_DIR;
    }
}

