/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business;

import br.com.fiorilli.instalador.business.AtualizadorServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.ConfiguraVirtualHost;
import br.com.fiorilli.instalador.business.InstaladorProgress;
import br.com.fiorilli.instalador.business.IsswebServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.ModuloServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.ScpiServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.ServicosWebServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.SincronizadorServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.SipwebServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.model.Modulo;
import br.com.fiorilli.instalador.model.Params;
import br.com.fiorilli.instalador.util.cli.JBossCli;
import br.com.fiorilli.instalador.util.ftp.FTPUtil;
import br.com.fiorilli.instalador.util.http.FileDownloader;
import br.com.fiorilli.instalador.vo.ArquivoVO;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ModuloService {
    static Logger logger = Logger.getLogger(ModuloService.class);
    private Params params;
    private InstaladorProgress progress;

    public void instalar(Modulo modulo, Params params, InstaladorProgress progress) {
        this.params = params;
        this.progress = progress;
        try {
            this.download(modulo);
        }
        catch (MalformedURLException e) {
            logger.error(e);
            throw new RuntimeException(e);
        }
        try {
            this.publicar(modulo);
        }
        catch (Throwable e) {
            logger.error(e);
            throw new RuntimeException(e);
        }
    }

    private boolean isDoubleExtention(String nomeArquivo) {
        return nomeArquivo.indexOf(".") < nomeArquivo.lastIndexOf(".");
    }

    private void download(Modulo modulo) throws MalformedURLException {
        String nomeArquivo = FilenameUtils.getName(modulo.getUrlDownload());
        if (FilenameUtils.getExtension(nomeArquivo).equals("zip") && this.isDoubleExtention(nomeArquivo)) {
            nomeArquivo = nomeArquivo.replace(".zip", "");
        }
        String extention = FilenameUtils.getExtension(nomeArquivo);
        if (this.params.getDownloadFilePath() == null) {
            File file;
            if (!nomeArquivo.contains(modulo.getVersaoDisponivel())) {
                nomeArquivo = FilenameUtils.getBaseName(nomeArquivo).concat("-").concat(modulo.getVersaoDisponivel()).concat(".").concat(extention);
            }
            if ((file = new File(nomeArquivo)).exists()) {
                file.delete();
            }
            logger.info("Baixando " + modulo.getNome());
            if ("FTP".equals(modulo.getTipoDownload())) {
                this.downloadFtp(modulo, nomeArquivo);
            } else {
                this.downloadHttp(modulo, nomeArquivo);
            }
        } else {
            nomeArquivo = this.params.getDownloadFilePath();
        }
        logger.info(nomeArquivo);
        File deploy = new File(nomeArquivo);
        if (deploy.exists()) {
            modulo.setArquivoBaixado(new ArquivoVO(deploy));
            logger.info(String.valueOf(modulo.getNome()) + " baixado com sucesso. " + String.format("%,2dKB", modulo.getArquivoBaixado().getTamanhoEmKB()));
        } else {
            logger.info(String.valueOf(modulo.getNome()) + " n\u00e3o foi baixado");
        }
    }

    private void downloadFtp(Modulo modulo, String nomeArquivo) {
        try {
            String ftpServer = modulo.getUrlDownload().split("/")[0];
            String ftpDirectory = FilenameUtils.getPathNoEndSeparator(modulo.getUrlDownload()).replace(ftpServer, "").substring(1);
            FTPUtil.downloadFromFTP(ftpServer, modulo.getUsrDownload(), modulo.getPwdDownload(), false, this.params.isProxyUse(), this.params.getProxyIp(), this.params.getProxyPort(), this.params.getProxyUser(), this.params.getProxyPasswd(), FilenameUtils.getName(modulo.getUrlDownload()), nomeArquivo, ftpDirectory, this.progress);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void downloadHttp(Modulo modulo, String nomeArquivo) {
        try {
            URL url = new URL(modulo.getTipoDownload().concat("://").concat(modulo.getUrlDownload()));
            FileDownloader.downloadFile(url, nomeArquivo, this.progress);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void publicar(Modulo modulo) throws Throwable {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JBossCli cli = new JBossCli(this.params.getJbossIp(), this.params.getJbossPort());){
            File file;
            ModuloServiceInfraDependencyResolver moduloInfraDependencyResolver = this.createModuloInfraDependencyResolver(modulo);
            if (moduloInfraDependencyResolver != null) {
                moduloInfraDependencyResolver.resolve(cli);
            }
            try {
                file = modulo.getArquivoBaixado().getFile();
            }
            catch (NullPointerException e) {
                logger.error("Arquivo j\u00e1 baixado n\u00e3o encontrado");
                throw e;
            }
            String deploybasename = file.getName();
            int dashpos = deploybasename.indexOf("-");
            deploybasename = deploybasename.substring(0, dashpos);
            if (!StringUtils.isEmpty(this.params.getVirtualHost())) {
                logger.info("Configurando Virtual Host");
                new ConfiguraVirtualHost().configuraModulo(file, this.params);
            }
            logger.info("Instalando M\u00f3dulo " + modulo.getNome());
            cli.deploy(file, deploybasename);
            if (cli.getErrors().size() == 0) {
                logger.info(String.valueOf(modulo.getNome()) + " Instalado com Sucesso");
            } else {
                Collection<Throwable> errors = cli.getErrors();
                Iterator<Throwable> iterator = errors.iterator();
                if (iterator.hasNext()) {
                    Throwable throwable2 = iterator.next();
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private ModuloServiceInfraDependencyResolver createModuloInfraDependencyResolver(Modulo modulo) {
        String context = modulo.getContexto().toLowerCase();
        if (context.contains("sipweb")) {
            return new SipwebServiceInfraDependencyResolver(this.params);
        }
        if (context.contains("scpi")) {
            return new ScpiServiceInfraDependencyResolver(this.params);
        }
        if (context.toLowerCase().contains("atualizador")) {
            return new AtualizadorServiceInfraDependencyResolver(this.params);
        }
        if (context.toLowerCase().contains("sincronizador")) {
            return new SincronizadorServiceInfraDependencyResolver(this.params);
        }
        if (context.toLowerCase().contains("issweb")) {
            return new IsswebServiceInfraDependencyResolver(this.params);
        }
        if (context.toLowerCase().contains("servicosweb")) {
            return new ServicosWebServiceInfraDependencyResolver(this.params);
        }
        return null;
    }
}

