/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business;

import br.com.fiorilli.instalador.business.ModuloServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.model.Params;
import br.com.fiorilli.instalador.util.cli.JBossCli;
import br.com.fiorilli.instalador.vo.DatasourceVO;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;
import org.ini4j.Wini;

public abstract class SiaServiceInfraDependencyResolverBasic
implements ModuloServiceInfraDependencyResolver {
    protected static final String JNDI_NAME = "java:/jdbc/";
    private static final Logger logger = Logger.getLogger(SiaServiceInfraDependencyResolverBasic.class);
    private Params params;

    protected abstract String getDatasourceName();

    protected String getJndiName() {
        return JNDI_NAME + this.getDatasourceName();
    }

    public SiaServiceInfraDependencyResolverBasic(Params params) {
        this.params = params;
    }

    @Override
    public void resolve(JBossCli cli) throws Exception {
        if (!cli.checkIfDatasourceExists(this.getDatasourceName())) {
            this.createDatasource(cli);
        }
    }

    private void createDatasource(JBossCli cli) throws Exception {
        logger.info("Criando Datasource " + this.getDatasourceName());
        DatasourceVO datasource = new DatasourceVO();
        datasource.setDatasourceName(this.getDatasourceName());
        datasource.setJndiName(JNDI_NAME);
        datasource.setConnectionUrl(this.getConnectionUrlFromIni());
        datasource.setDriverName("jaybird_2.2.4");
        datasource.setDriverClass("org.firebirdsql.jdbc.FBDriver");
        datasource.setUserName("fscsia");
        datasource.setPassword("csfais");
        datasource.setMinPoolSize(5);
        datasource.setMaxPoolSize(15);
        datasource.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        datasource.setUseCcm(false);
        datasource.setUseJta(true);
        cli.createDatasource(datasource);
        logger.info("Datasource criado com sucesso");
        cli.enableDatasource(datasource.getDatasourceName());
        logger.info("Datasource habilitado com sucesso");
    }

    private String getConnectionUrlFromIni() throws InvalidFileFormatException, IOException {
        Wini ini = new Wini(new File(this.params.getSiaIni()));
        Profile.Section section = (Profile.Section)ini.get("SIA");
        String servidor = (String)section.get("SERVIDOR");
        String porta = (String)section.get("PORTACON");
        String caminho = ((String)section.get("Caminho_Base_Dados")).replaceAll("(\\\\+|/+)", Matcher.quoteReplacement("/"));
        return new MessageFormat("jdbc:firebirdsql:{0}/{1}:{2}?lc_ctype=WIN1252").format(new Object[]{servidor, porta, caminho});
    }
}

