/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business;

import br.com.fiorilli.instalador.business.ModuloServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.model.Params;
import br.com.fiorilli.instalador.util.cli.JBossCli;
import br.com.fiorilli.instalador.vo.DatasourceVO;
import br.com.fiorilli.instalador.vo.SecurityDomainVO;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;
import org.ini4j.Wini;

public class SipwebServiceInfraDependencyResolver
implements ModuloServiceInfraDependencyResolver {
    public static final String DATASOURCE_NAME = "SipWebFirebird";
    private static final String JNDI_NAME = "java:/SipWebFirebird";
    private static final String SECURITY_DOMAIN_NAME = "SipwebSecurityDomain";
    public static final String CONNECTION_PARAMS = "defaultHoldable=true&encoding=WIN1252";
    private static final Logger logger = Logger.getLogger(SipwebServiceInfraDependencyResolver.class);
    private Params params;

    public SipwebServiceInfraDependencyResolver(Params params) {
        this.params = params;
    }

    @Override
    public void resolve(JBossCli cli) throws Exception {
        if (!cli.checkIfSecurityDomainExists(SECURITY_DOMAIN_NAME)) {
            this.createSecurityDomain(cli);
        }
        if (!cli.checkIfDatasourceExists(DATASOURCE_NAME)) {
            this.createDatasource(cli);
        }
    }

    private void createSecurityDomain(JBossCli cli) throws Exception {
        logger.info("Criando SIPWeb Security Domain");
        SecurityDomainVO securityDomainVO = new SecurityDomainVO();
        securityDomainVO.setName(SECURITY_DOMAIN_NAME);
        securityDomainVO.setUsername("fscsip");
        securityDomainVO.setPassword("sip");
        securityDomainVO.setFlag("required");
        cli.createSecurityDomain(securityDomainVO);
        logger.info("Security Domain SIPWeb criado com sucesso");
    }

    private void createDatasource(JBossCli cli) throws Exception {
        logger.info("Criando Datasource SIPWeb");
        DatasourceVO datasource = new DatasourceVO();
        datasource.setDatasourceName(DATASOURCE_NAME);
        datasource.setJndiName(JNDI_NAME);
        datasource.setConnectionUrl(this.getConnectionUrlFromSipIni());
        datasource.setDriverName("jaybird_2.2.4");
        datasource.setDriverClass("org.firebirdsql.jdbc.FBDriver");
        datasource.setSecurityDomain(SECURITY_DOMAIN_NAME);
        datasource.setUseSecurityDomain(true);
        datasource.setMinPoolSize(5);
        datasource.setMaxPoolSize(15);
        datasource.setCheckValidConnectionSql("select * from empresa");
        datasource.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        datasource.setUseCcm(false);
        datasource.setUseJta(true);
        datasource.setPrefill(true);
        cli.createDatasource(datasource);
        logger.info("Datasource SIPWeb criado com sucesso");
        cli.enableDatasource(datasource.getDatasourceName());
        logger.info("Datasource SIPWeb habilitado com sucesso");
    }

    private String getConnectionUrlFromSipIni() throws InvalidFileFormatException, IOException {
        Wini ini = new Wini(new File(this.params.getSipIni()));
        Profile.Section servidor = (Profile.Section)ini.get("SERVIDOR");
        String caminho = ((String)((Profile.Section)ini.get("SIP")).get("Caminho")).replaceAll("(\\\\+|/+)", Matcher.quoteReplacement("/"));
        return new MessageFormat("jdbc:firebirdsql:{0}/{1}:{2}?{3}").format(new Object[]{servidor.get("NOME"), servidor.get("PORTA"), caminho, CONNECTION_PARAMS});
    }
}

