/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.console;

import br.com.fiorilli.instalador.business.DeployService;
import br.com.fiorilli.instalador.business.InstaladorProgress;
import br.com.fiorilli.instalador.business.InstaladorProgressNullObj;
import br.com.fiorilli.instalador.business.InstallJBossService;
import br.com.fiorilli.instalador.business.ModuloService;
import br.com.fiorilli.instalador.console.InstaladorProgressBarConsole;
import br.com.fiorilli.instalador.model.Modulo;
import br.com.fiorilli.instalador.model.Params;
import br.com.fiorilli.instalador.model.RepositorioDeModulos;
import br.com.fiorilli.instalador.model.VersaoInstaladaNaoInformadaException;
import br.com.fiorilli.util.VersionControl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class ConsoleApp {
    private static Logger logger;
    private static final String DEBUG_CMD = "debug";
    private static final String INSTALAR_MODULO_ID_PARAM = "id";
    private static final String DOWNLOAD_PARAM = "download";
    private static final String PROXY_PWD_PARAM = "proxy-pwd";
    private static final String PROXY_USR_PARAM = "proxy-usr";
    private static final String PROXY_PORTA_PARAM = "proxy-port";
    private static final String PROXY_IP_PARAM = "proxy-ip";
    private static final String SIP_INI_PARAM = "sip-ini";
    private static final String SIA_INI_PARAM = "sia-ini";
    private static final String SCPI_INI_PARAM = "scpi-ini";
    private static final String JBOSS_PORTA_PARAM = "jboss-port";
    private static final String JBOSS_IP_PARAM = "jboss-ip";
    private static final String VIRTUAL_HOST_PARAM = "virtual-host";
    private static final String SALVAR_LOG_CMD = "salvar-log";
    private static final String ARQUIVO_LOG_PARAM = "arquivo-log";
    private static final String INSTALAR_JBOSS_DIR_PARAM = "jboss-dir";
    private static final String INSTALAR_MODULO_CMD = "instalar-modulo";
    private static final String INSTALAR_JBOSS_MODE_PARAM = "mode";
    private static final String INSTALAR_JBOSS_CMD = "instalar-jboss";
    private static final String LISTAR_MODULOS_CMD = "listar-modulos";
    private static final String EXEMPLOS_CMD = "ex";
    private static final String JDK_DIR_PARAM = "jdk-dir";
    private static final String ATUALIZAR_PARAM = "atualizar-modulo";
    private static final List<String> arglist;
    private static final String INSTALAR_JBOSS_HELP_PARAM = "help";
    private static final String SHOW_VERSAO = "versao";
    private static String[] modulosIds;
    private static List<Modulo> modulos;
    private static InstaladorProgress progress;
    private static Params params;

    public static void main(String[] args) {
        Collections.addAll(arglist, args);
        ConsoleApp.configureLogger();
        logger = Logger.getLogger(ConsoleApp.class);
        if (args.length == 0 || args[0].toLowerCase().equals("/?") || args[0].toLowerCase().equals("--help") || args[0].toLowerCase().equals(INSTALAR_JBOSS_HELP_PARAM)) {
            ConsoleApp.printHelp();
            ConsoleApp.checkInstaladorNewVersion();
        } else if (args.length == 1 && args[0].toLowerCase().equals(EXEMPLOS_CMD)) {
            ConsoleApp.printExemplos();
            ConsoleApp.checkInstaladorNewVersion();
        } else {
            ConsoleApp.checkInstaladorNewVersion();
            ConsoleApp.buildParams();
            try {
                if (arglist.contains(LISTAR_MODULOS_CMD)) {
                    ConsoleApp.listarModulos();
                } else if (arglist.contains(INSTALAR_JBOSS_CMD)) {
                    if (arglist.contains(INSTALAR_JBOSS_HELP_PARAM)) {
                        ConsoleApp.printInstalarJBossHelp();
                    } else {
                        ConsoleApp.instalarJBoss();
                    }
                } else if (arglist.contains(INSTALAR_MODULO_CMD)) {
                    ConsoleApp.instalarModulo();
                } else if (arglist.contains(ATUALIZAR_PARAM)) {
                    ConsoleApp.atualizarModulos();
                } else if (arglist.contains(SHOW_VERSAO)) {
                    ConsoleApp.printVersion();
                } else {
                    logger.error("Parametro invalido");
                }
            }
            catch (Exception e) {
                if (arglist.contains(DEBUG_CMD)) {
                    e.printStackTrace();
                } else {
                    logger.error(e);
                }
            }
            finally {
                logger.info("\n");
            }
        }
    }

    private static void atualizarModulo(Modulo modulo, ModuloService moduloService) throws Exception {
        try {
            logger.info("Verificando atualiza\u00e7\u00e3o do " + modulo.getNome());
            if (modulo.isUpdate()) {
                logger.info("Atualizando m\u00f3dulo");
                moduloService.instalar(modulo, ConsoleApp.getParams(), progress);
            } else {
                logger.info("N\u00e3o \u00e9 necess\u00e1rio atualizar o m\u00f3dulo");
            }
        }
        catch (Exception e) {
            if (!(e instanceof VersaoInstaladaNaoInformadaException)) {
                throw e;
            }
            logger.info("M\u00f3dulo n\u00e3o instalado");
        }
    }

    private static void atualizarModulos() throws Exception {
        ConsoleApp.loadModulos();
        DeployService deployService = new DeployService();
        deployService.verificarVersoes(ConsoleApp.getParams(), modulos);
        ModuloService moduloService = new ModuloService();
        if (modulosIds != null && modulosIds.length > 0) {
            for (String id : modulosIds) {
                if (StringUtils.isNumeric(id)) {
                    Modulo modulo = ConsoleApp.findModuloById(Integer.parseInt(id));
                    if (modulo != null) {
                        ConsoleApp.atualizarModulo(modulo, moduloService);
                        continue;
                    }
                    logger.error("M\u00f3dulo n\u00e3o encontrado id=" + id);
                    continue;
                }
                logger.error("M\u00f3dulo Inv\u00e1lido id=" + id + ", informe um n\u00famero.");
            }
        } else {
            for (Modulo modulo : modulos) {
                ConsoleApp.atualizarModulo(modulo, moduloService);
            }
        }
    }

    private static void printVersion() {
        logger.info("Versao deste instalador: " + ConsoleApp.getVersao());
    }

    private static void checkInstaladorNewVersion() {
        String versaoInstalada;
        RepositorioDeModulos repo = new RepositorioDeModulos();
        String versaoDisponivel = repo.getInstaladorVersion();
        if (VersionControl.isVersaoDisponivelSuperior(versaoDisponivel, versaoInstalada = ConsoleApp.getVersao())) {
            logger.info("\n/------------------------------------------------------------------\\\n| Nova Vers\u00e3o do Instalador Dispon\u00edvel.                            |\n| Acesse www.fiorilli.com.br/instalador para baixar a atualiza\u00e7\u00e3o. |\n| Versao Instalada:  " + versaoInstalada + "                                         |\n| Versao Disponivel: " + versaoDisponivel + "                                         |\n\\------------------------------------------------------------------/");
        }
    }

    private static String getVersao() {
        return "1.5.5";
    }

    private static void loadModulos() {
        modulos = new ArrayList<Modulo>();
        new RepositorioDeModulos().load(modulos, false);
    }

    private static void listarModulos() throws Exception {
        ConsoleApp.loadModulos();
        DeployService deployService = new DeployService();
        deployService.verificarVersoes(ConsoleApp.getParams(), modulos);
        int maxLengthNome = 0;
        int maxLengthVersaoDisponivel = "Versao Disponivel".length();
        for (Modulo modulo : modulos) {
            if (modulo.getNome().length() > maxLengthNome) {
                maxLengthNome = modulo.getNome().length();
            }
            if (modulo.getVersaoDisponivel().length() <= maxLengthVersaoDisponivel) continue;
            maxLengthVersaoDisponivel = modulo.getVersaoDisponivel().length();
        }
        logger.info("");
        StringBuilder sb = new StringBuilder();
        sb.append("#Id|");
        sb.append(String.format("%-" + maxLengthNome + "s", "Nome") + " |");
        sb.append(String.format("%-" + maxLengthVersaoDisponivel + "s", "Versao Disponivel") + " |");
        sb.append("Versao Instalada");
        logger.info(sb.toString());
        for (int i = 0; i < modulos.size(); ++i) {
            Modulo modulo = modulos.get(i);
            sb = new StringBuilder();
            sb.append("#" + String.format("%2s", modulo.getId()) + "|");
            sb.append(String.format("%-" + maxLengthNome + "s", modulo.getNome()) + " |");
            sb.append(String.format("%-" + maxLengthVersaoDisponivel + "s", modulo.getVersaoDisponivel()) + " |");
            if (modulo.getVersaoInstalada() != null) {
                sb.append(modulo.getVersaoInstalada());
            }
            logger.info(sb.toString());
        }
        if (modulos.size() > 0) {
            logger.info("");
            int randomIndex = new Random().nextInt(modulos.size());
            sb = new StringBuilder();
            sb.append("Para instalar o ");
            sb.append(modulos.get(randomIndex).getNome());
            sb.append(" execute:\n");
            if (SystemUtils.IS_OS_WINDOWS) {
                sb.append("instalador ");
            } else {
                sb.append("./instalador");
            }
            sb.append("instalar-modulo id=");
            sb.append(Integer.toString(randomIndex + 1));
            logger.info(sb.toString());
        }
    }

    private static void buildParams() {
        String jbossIp = null;
        int jbossPort = 0;
        String jbossUsr = null;
        String jbossPwd = null;
        String jbossDir = null;
        String scpiIni = null;
        String siaIni = null;
        String sipIni = null;
        boolean proxyUse = false;
        String proxyIp = null;
        int proxyPort = 0;
        String proxyUser = null;
        String proxyPasswd = null;
        String virtualHost = null;
        String downloadFilePath = null;
        String jdkDir = null;
        Params.JBossMode jbossMode = null;
        boolean debug = false;
        try {
            for (int i = 0; i < arglist.size(); ++i) {
                String arg = arglist.get(i);
                if (arg.contains(JBOSS_IP_PARAM)) {
                    jbossIp = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(JBOSS_PORTA_PARAM)) {
                    jbossPort = Integer.parseInt(arg.split("=")[1]);
                    continue;
                }
                if (arg.contains(INSTALAR_JBOSS_DIR_PARAM)) {
                    jbossDir = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(INSTALAR_MODULO_ID_PARAM)) {
                    modulosIds = arg.split("=")[1].split(",");
                    continue;
                }
                if (arg.contains(SCPI_INI_PARAM)) {
                    scpiIni = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(SIP_INI_PARAM)) {
                    sipIni = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(SIA_INI_PARAM)) {
                    siaIni = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(VIRTUAL_HOST_PARAM)) {
                    virtualHost = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(DOWNLOAD_PARAM)) {
                    downloadFilePath = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(JDK_DIR_PARAM)) {
                    jdkDir = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(INSTALAR_JBOSS_MODE_PARAM)) {
                    jbossMode = Params.JBossMode.valueOf(arg.split("=")[1].toUpperCase());
                    continue;
                }
                if (!arg.contains(DEBUG_CMD)) continue;
                debug = true;
            }
            params = new Params(jbossIp, jbossPort, jbossUsr, jbossPwd, jbossDir, scpiIni, siaIni, sipIni, proxyUse, proxyIp, proxyPort, proxyUser, proxyPasswd, virtualHost, downloadFilePath, jdkDir, jbossMode, debug);
        }
        catch (Exception e) {
            logger.error("Par\u00e2metro ou Op\u00e7\u00e3o Inv\u00e1lida");
            throw e;
        }
    }

    private static Params getParams() {
        if (params == null) {
            ConsoleApp.buildParams();
        }
        return params;
    }

    private static void printExemplos() {
        logger.info("Exemplo 1 (Instalar o JBoss numa pasta diferente da padrao para o SO):");
        logger.info("    instalador instalar-jboss jboss-dir=" + Params.getDefaultJBossDir());
        logger.info("Exemplo 2 (Listar os modulos disponiveis para download e verificar a versao):");
        logger.info("    instalador listar-modulos");
        logger.info("Exemplo 3 (Instalar um modulo):");
        logger.info("    instalador instalar-modulo id=1");
        logger.info("Exemplo 4 (instalar um modulo com virtual-host):");
        logger.info("    instalador instalar-modulo id=1 virtual-host=sipweb jdk-dir=" + Params.getDefaultJBossDir() + File.separator + InstallJBossService.getDirName() + File.separator + "jdk");
        logger.info("Exemplo 5 (instalar um modulo com download ja realizado):");
        logger.info("    instalador instalar-modulo id=1 download=c:\\fiorilli\\sip_7\\sipweb.ear");
        logger.info("Exemplo 6 (instalar um modulo com virtual-host com download ja realizado):");
        logger.info("    misturar os exemplos 4 e 5");
    }

    private static void configureLogger() {
        ConsoleAppender console = new ConsoleAppender();
        String PATTERN = "%m%n";
        console.setLayout(new PatternLayout(PATTERN));
        console.setEncoding("utf-8");
        console.setThreshold(Level.INFO);
        console.activateOptions();
        Logger.getRootLogger().addAppender(console);
        FileAppender fa = new FileAppender();
        fa.setName("Instalador-Log-File");
        fa.setFile(ConsoleApp.getLogFileName());
        fa.setLayout(new PatternLayout("%d{yyyy-MM-dd HH:mm:ss} %-5p: %m%n"));
        fa.setThreshold(Level.INFO);
        fa.setAppend(true);
        fa.activateOptions();
        Logger.getRootLogger().addAppender(fa);
    }

    private static void printInstalarJBossHelp() {
        new InstallJBossService(ConsoleApp.getParams(), new InstaladorProgressNullObj()).helpUnixUser();
    }

    private static String getLogFileName() {
        for (String arg : arglist) {
            if (!arg.contains(ARQUIVO_LOG_PARAM)) continue;
            return arg.split("=")[1];
        }
        return "Instalador.log.txt";
    }

    private static void instalarModulo() {
        if (modulos == null) {
            ConsoleApp.loadModulos();
        }
        ModuloService moduloService = new ModuloService();
        for (String id : modulosIds) {
            if (StringUtils.isNumeric(id)) {
                Modulo modulo = ConsoleApp.findModuloById(Integer.parseInt(id));
                if (modulo != null) {
                    moduloService.instalar(modulo, ConsoleApp.getParams(), progress);
                    continue;
                }
                logger.error("M\u00f3dulo n\u00e3o encontradoid=" + id);
                continue;
            }
            logger.error("M\u00f3dulo Inv\u00e1lido id=" + id + ", informe um n\u00famero.");
        }
    }

    private static Modulo findModuloById(int id) {
        for (Modulo modulo : modulos) {
            if (modulo.getId() != id) continue;
            return modulo;
        }
        return null;
    }

    private static void instalarJBoss() throws IOException {
        new InstallJBossService(ConsoleApp.getParams(), progress).install();
    }

    private static void printHelp() {
        logger.info("<<INSTRUCOES>>\n");
        logger.info(INSTALAR_JBOSS_CMD);
        logger.info("Parametros:");
        logger.info("    jboss-dir (padrao=" + Params.getDefaultJBossDir() + ")");
        logger.info("    mode (ex: mode=domain) (padr\u00e3o=standalone)");
        logger.info("    help (exibe passos p\u00f3s-instala\u00e7\u00e3o novamente)");
        logger.info("");
        logger.info(LISTAR_MODULOS_CMD);
        logger.info("Parametros:");
        logger.info("    jboss-ip (padrao=" + Params.getDefaultLoopBackIp() + ")");
        logger.info("    jboss-port (padrao=" + Params.getDefaultJBossPort() + ")");
        logger.info("    proxy-ip");
        logger.info("    proxy-port");
        logger.info("    proxy-usr");
        logger.info("    proxy-pwd");
        logger.info("");
        logger.info(INSTALAR_MODULO_CMD);
        logger.info("Parametros:");
        logger.info("    id=[numeros dos modulos separados por virgula do comando listar-modulos]");
        logger.info("    scpi-ini (padrao=" + Params.getDefaultScpiIni() + ")");
        logger.info("    sia-ini (padrao=" + Params.getDefaultSiaIni() + ")");
        logger.info("    sip-ini (padrao=" + Params.getDefaultSipIni() + ")");
        logger.info("    download (caminho completo do arquivo baixado)");
        logger.info("    virtual-host (nome do virtual-host jdk-dir obrigatorio)");
        logger.info("    jdk-dir (caminho completo da JDK sem barra final)");
        logger.info("");
        logger.info(SALVAR_LOG_CMD);
        logger.info("Parametros:");
        logger.info("    arquivo-log=[caminho completo com nome do arquivo]");
        logger.info("");
        logger.info(DEBUG_CMD);
        logger.info("    (indicador para printStackTrace quando houver erros)");
        logger.info(EXEMPLOS_CMD);
        logger.info("    (Exibir Exemplos)");
        logger.info(SHOW_VERSAO);
        logger.info("    (Exibir a Versao Deste Instalador)");
    }

    static {
        arglist = new ArrayList<String>();
        progress = new InstaladorProgressBarConsole();
    }
}

