/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.model;

import br.com.fiorilli.instalador.model.Modulo;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class RepositorioDeModulos {
    private static final String URI_RELEASE = "/release";
    private static final String URI_PRIMARIA_INSTALADOR_CENTRAL = "http://fi1.fiorilli.com.br:5665/central/rest/modulos";
    private static final String URI_SECUNDARIA_INSTALADOR_CENTRAL = "http://fi2.fiorilli.com.br:5665/central/rest/modulos";
    static Logger logger = Logger.getLogger(RepositorioDeModulos.class);

    public void load(List<Modulo> result, boolean release) {
        block6: {
            if (result == null) {
                throw new IllegalArgumentException("Informe o argumento j\u00e1 instanciado");
            }
            try {
                logger.info("Recuperando M\u00f3dulos Dispon\u00edveis");
                HttpURLConnection conn = this.buildHttpConnection(release);
                if (conn == null) break block6;
                try {
                    Modulo[] restItems = this.getModulosFromConnection(conn);
                    Collections.addAll(result, restItems);
                }
                finally {
                    conn.disconnect();
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    private Modulo[] getModulosFromConnection(HttpURLConnection conn) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        Modulo[] restItems = new Gson().fromJson((Reader)br, Modulo[].class);
        logger.info(String.valueOf(restItems.length) + " m\u00f3dulos dispon\u00edveis");
        br.close();
        return restItems;
    }

    private HttpURLConnection buildHttpConnection(boolean release) throws IOException {
        HttpURLConnection result = this.buildHttpConnection(URI_PRIMARIA_INSTALADOR_CENTRAL, release);
        if (result.getResponseCode() == 200) {
            return result;
        }
        result = this.buildHttpConnection(URI_SECUNDARIA_INSTALADOR_CENTRAL, release);
        if (result.getResponseCode() == 200) {
            return result;
        }
        return null;
    }

    private HttpURLConnection buildHttpConnection(String path, boolean release) throws IOException {
        URL url = new URL(String.valueOf(path) + (release ? URI_RELEASE : ""));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json");
        return conn;
    }

    public String getInstaladorVersion() {
        String versao = "";
        try {
            URL url = new URL("http://www.fiorilli.com.br/instalador/versao.txt");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            try {
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Accept", "text/plain");
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    versao = br.readLine();
                }
            }
            finally {
                conn.disconnect();
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return versao;
    }
}

