/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.util.cli;

import br.com.fiorilli.instalador.util.cli.CliException;
import br.com.fiorilli.instalador.util.enums.Status;
import br.com.fiorilli.instalador.vo.DatasourceVO;
import br.com.fiorilli.instalador.vo.DeployVO;
import br.com.fiorilli.instalador.vo.HeapVO;
import br.com.fiorilli.instalador.vo.JBossVO;
import br.com.fiorilli.instalador.vo.JdbcDriverVO;
import br.com.fiorilli.instalador.vo.MemoriaVO;
import br.com.fiorilli.instalador.vo.PoolStatisticsVO;
import br.com.fiorilli.instalador.vo.SecurityDomainVO;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.standalone.ServerUpdateActionResult;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class JBossCli
implements Closeable {
    private static final Logger logger = Logger.getLogger(JBossCli.class);
    private static final long DEFAULT_TIMEOUT = 60000L;
    private final long timeout = 60000L;
    private static final String RECURSIVE = "recursive";
    private static final String INCLUDE_RUNTIME = "include-runtime";
    private static final String SUBDEPLOYMENT = "subdeployment";
    private static final String SUBSYSTEM = "subsystem";
    private static final String READ_ATTRIBUTE_OPERATION = "read-attribute";
    private static final String READ_RESOURCE_OPERATION = "read-resource";
    private static final String READ_CHILDREN_NAMES = "read-children-names";
    private static final String READ_CHILDREN_RESOURCES = "read-children-resources";
    private static final String WEB = "web";
    private static final String NAME = "name";
    private static final String POSTFIX_WEB = ".war";
    private static final String POSTFIX_EAR = ".ear";
    protected static final String FIORILLI_JBOSS_USERNAME = "fiorilli";
    protected static final String FIORILLI_JBOSS_PASSWORD = "srvjavafiorilli!";
    private URI webUri;
    private ModelNode rootNode = null;
    private final ModelControllerClient client;
    private List<Throwable> errors;

    public JBossCli(String servidor, int porta) throws CliException {
        try {
            CallbackHandler authCallback = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    Callback[] callbackArray = callbacks;
                    int n = callbacks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Callback callback = callbackArray[n2];
                        if (callback instanceof RealmCallback) {
                            RealmCallback realmCallback = (RealmCallback)callback;
                            realmCallback.setText(realmCallback.getDefaultText());
                        } else if (callback instanceof NameCallback) {
                            NameCallback userNameCallback = (NameCallback)callback;
                            userNameCallback.setName(JBossCli.FIORILLI_JBOSS_USERNAME);
                        } else if (callback instanceof PasswordCallback) {
                            PasswordCallback passwordCallback = (PasswordCallback)callback;
                            passwordCallback.setPassword(JBossCli.FIORILLI_JBOSS_PASSWORD.toCharArray());
                        }
                        ++n2;
                    }
                }
            };
            this.client = ModelControllerClient.Factory.create(InetAddress.getByName(servidor), porta, authCallback);
        }
        catch (UnknownHostException e) {
            throw new CliException(e);
        }
    }

    public void createSystemProperty(String key, String value) throws CliException {
        ModelNode address = new ModelNode();
        address.add("system-property", key);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("value").set(value);
        this.execute(operation).asString();
    }

    public List<DeployVO> getDeployments() throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set(READ_CHILDREN_RESOURCES);
        request.get("child-type").set("deployment");
        request.get(RECURSIVE).set(true);
        ModelNode response = this.execute(request);
        if (!response.isDefined()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DeployVO> deployVOList = new ArrayList<DeployVO>();
        for (ModelNode deployment : response.asList()) {
            DeployVO deployVO = new DeployVO();
            deployVO.setName(deployment.asProperty().getName());
            ModelNode dataValues = deployment.asProperty().getValue();
            deployVO.setEnabled(dataValues.get("enabled").asBoolean());
            deployVO.setRuntimeName(dataValues.get("runtime-name").asString());
            deployVO.setContexts(this.getContextsNames(deployment.asProperty().getName()));
            deployVOList.add(deployVO);
        }
        return deployVOList;
    }

    private Set<String> getDeploymentNames() throws CliException {
        ModelNode op = new ModelNode();
        op.get("operation").set(READ_CHILDREN_NAMES);
        op.get("child-type").set("deployment");
        ModelNode result = this.execute(op);
        HashSet<String> names = new HashSet<String>();
        if (!result.isDefined()) {
            return Collections.emptySet();
        }
        for (ModelNode deployment : result.asList()) {
            names.add(deployment.asString());
        }
        return names;
    }

    public Status selfDeployment(String activeDeploy, File newDeploy) throws CliException {
        DeploymentPlan plan;
        Status status = Status.SUCCESS;
        ServerDeploymentManager manager = ServerDeploymentManager.Factory.create(this.client);
        InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
        try {
            plan = builder.undeploy(activeDeploy).remove(activeDeploy).add(newDeploy).deploy(newDeploy.getName()).build();
        }
        catch (IOException e) {
            throw new CliException(e);
        }
        if (plan == null) {
            throw new IllegalStateException("A\ufffd\ufffdo Inv\ufffdlida");
        }
        if (plan.getDeploymentActions().size() > 0) {
            try {
                ServerDeploymentPlanResult planResult = manager.execute(plan).get(60000L, TimeUnit.MILLISECONDS);
                for (DeploymentAction deploymentAction : plan.getDeploymentActions()) {
                    ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(deploymentAction.getId());
                    ServerUpdateActionResult.Result result = actionResult.getResult();
                    switch (result) {
                        case FAILED: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            status = Status.FAILED;
                            break;
                        }
                        case NOT_EXECUTED: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            status = Status.NOT_EXECUTED;
                            break;
                        }
                        case ROLLED_BACK: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            status = Status.ROLLED_BACK;
                            break;
                        }
                        case CONFIGURATION_MODIFIED_REQUIRES_RESTART: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            status = Status.CONFIGURATION_MODIFIED_REQUIRES_RESTART;
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.error(e);
                this.getErrors().add(e);
            }
        }
        return status;
    }

    private void executePlan(ServerDeploymentManager manager, DeploymentPlan plan) {
        if (plan.getDeploymentActions().size() > 0) {
            try {
                ServerDeploymentPlanResult planResult = manager.execute(plan).get(60000L, TimeUnit.MILLISECONDS);
                for (DeploymentAction deploymentAction : plan.getDeploymentActions()) {
                    ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(deploymentAction.getId());
                    ServerUpdateActionResult.Result result = actionResult.getResult();
                    switch (result) {
                        case FAILED: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            break;
                        }
                        case NOT_EXECUTED: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            break;
                        }
                        case ROLLED_BACK: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            break;
                        }
                        case CONFIGURATION_MODIFIED_REQUIRES_RESTART: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.error(e);
                this.getErrors().add(e);
            }
        }
    }

    public void undeploy(String deploymentname) {
        ServerDeploymentManager manager = ServerDeploymentManager.Factory.create(this.client);
        InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
        DeploymentPlan undeployplan = builder.undeploy(deploymentname).build();
        this.executePlan(manager, undeployplan);
    }

    public void removeDeploy(String deploymentname) {
        ServerDeploymentManager manager = ServerDeploymentManager.Factory.create(this.client);
        InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
        DeploymentPlan undeployplan = builder.remove(deploymentname).build();
        this.executePlan(manager, undeployplan);
    }

    private void removeDeployFromBaseName(String deploymentbasename) throws CliException {
        Set<String> deploymentNames = this.getDeploymentNames();
        for (String name : deploymentNames) {
            if (!name.toLowerCase().contains(deploymentbasename.toLowerCase())) continue;
            this.removeDeploy(name);
        }
    }

    public void deploy(File deployment, String deploymentbasename) throws CliException {
        this.removeDeployFromBaseName(deploymentbasename);
        ServerDeploymentManager manager = ServerDeploymentManager.Factory.create(this.client);
        InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
        try {
            DeploymentPlan addplan = builder.add(deployment).build();
            this.executePlan(manager, addplan);
            DeploymentPlan deployplan = builder.deploy(deployment.getName()).build();
            this.executePlan(manager, deployplan);
        }
        catch (IOException e) {
            throw new CliException(e);
        }
    }

    @Deprecated
    public Status doDeploymentAction(Object archive, DeploymentAction.Type action) throws CliException {
        DeploymentPlan plan;
        Status status = Status.SUCCESS;
        ServerDeploymentManager manager = ServerDeploymentManager.Factory.create(this.client);
        InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
        File deploy = null;
        String deployName = null;
        if (archive instanceof File) {
            deploy = (File)archive;
        } else {
            deployName = (String)archive;
        }
        try {
            switch (action) {
                case DEPLOY: {
                    plan = builder.deploy(deployName).build();
                    break;
                }
                case REPLACE: {
                    plan = builder.add(deploy).deploy(deploy.getName()).build();
                    break;
                }
                case FULL_REPLACE: {
                    plan = builder.replace(deploy).redeploy(deploy.getName()).build();
                    break;
                }
                case REDEPLOY: {
                    plan = builder.redeploy(deployName).build();
                    break;
                }
                case UNDEPLOY: {
                    plan = builder.undeploy(deployName).build();
                    break;
                }
                case ADD: {
                    plan = builder.add(deploy).build();
                    break;
                }
                case REMOVE: {
                    plan = builder.undeploy(deployName).remove(deployName).build();
                    break;
                }
                default: {
                    plan = null;
                    status = Status.NOT_EXECUTED;
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new CliException(e);
        }
        if (plan == null) {
            throw new IllegalStateException("A\ufffd\ufffdo Inv\ufffdlida: " + (Object)((Object)action));
        }
        if (plan.getDeploymentActions().size() > 0) {
            try {
                ServerDeploymentPlanResult planResult = manager.execute(plan).get(60000L, TimeUnit.MILLISECONDS);
                for (DeploymentAction deploymentAction : plan.getDeploymentActions()) {
                    ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(deploymentAction.getId());
                    ServerUpdateActionResult.Result result = actionResult.getResult();
                    switch (result) {
                        case FAILED: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            status = Status.FAILED;
                            break;
                        }
                        case NOT_EXECUTED: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            status = Status.NOT_EXECUTED;
                            break;
                        }
                        case ROLLED_BACK: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            status = Status.ROLLED_BACK;
                            break;
                        }
                        case CONFIGURATION_MODIFIED_REQUIRES_RESTART: {
                            this.getErrors().add(actionResult.getDeploymentException());
                            status = Status.CONFIGURATION_MODIFIED_REQUIRES_RESTART;
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.error(e);
                this.getErrors().add(e);
            }
        }
        return status;
    }

    public void reloadConfiguration() throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set("reload");
        this.execute(request);
    }

    public void removeDatasource(String datasourceName) throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set("remove");
        request.get("address").add(SUBSYSTEM, "datasources");
        request.get("address").add("data-source", datasourceName);
        this.execute(request);
    }

    public void testConnectionPool(String datasourceName) throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set("test-connection-in-pool");
        request.get("address").add(SUBSYSTEM, "datasources");
        request.get("address").add("data-source", datasourceName);
        this.execute(request);
    }

    public void enableDatasource(String datasourceName) throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set("enable");
        request.get("persistent").set(true);
        request.get("address").add(SUBSYSTEM, "datasources");
        request.get("address").add("data-source", datasourceName);
        this.execute(request);
        if (this.getServerState().equals("restart-required")) {
            this.reloadConfiguration();
        }
    }

    public void disableDatasource(String datasourceName) throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set("disable");
        request.get("allow-resource-service-restart").set(true);
        request.get("address").add(SUBSYSTEM, "datasources");
        request.get("address").add("data-source", datasourceName);
        this.execute(request);
        if (this.getServerState().equals("restart-required")) {
            this.reloadConfiguration();
        }
    }

    public void removeSecurityDomain(String securityDomainName) throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set("remove");
        request.get("address").add(SUBSYSTEM, "security");
        request.get("address").add("security-domain", securityDomainName);
        this.execute(request);
    }

    public static ModelNode createAddSecurityDomain(SecurityDomainVO securityDomainVO) throws CliException {
        ModelNode addDomain = new ModelNode();
        addDomain.get("operation").set("add");
        addDomain.get("address").add(SUBSYSTEM, "security").add("security-domain", securityDomainVO.getName());
        addDomain.get("cache-type").set("default");
        ModelNode addDomainContent = new ModelNode();
        addDomainContent.get("operation").set("add");
        addDomainContent.get("address").add(SUBSYSTEM, "security").add("security-domain", securityDomainVO.getName()).add("authentication", "classic");
        ModelNode loginModules = addDomainContent.get("login-modules");
        ModelNode remotingModule = new ModelNode();
        remotingModule.get("code").set(securityDomainVO.getLoginModule());
        remotingModule.get("flag").set(securityDomainVO.getFlag());
        ModelNode moduleOptions = remotingModule.get("module-options");
        String password = JBossCli.encode(securityDomainVO.getPassword());
        moduleOptions.get("password").set(password);
        moduleOptions.get("username").set(securityDomainVO.getUsername());
        loginModules.add(remotingModule);
        return JBossCli.createCompositeOp(Arrays.asList(addDomain, addDomainContent));
    }

    private static ModelNode createCompositeOp(Collection<ModelNode> operations) {
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        for (ModelNode current : operations) {
            steps.add(current);
        }
        return composite;
    }

    public void createSecurityDomain(SecurityDomainVO securityDomainVO) throws CliException {
        this.execute(JBossCli.createAddSecurityDomain(securityDomainVO));
    }

    public void createDatasource(DatasourceVO datasourceVO) throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set("add");
        request.get("address").add(SUBSYSTEM, "datasources");
        request.get("address").add("data-source", datasourceVO.getDatasourceName());
        request.get("jndi-name").set(datasourceVO.getJndiName());
        request.get("connection-url").set(datasourceVO.getConnectionUrl());
        request.get("driver-class").set(datasourceVO.getDriverClass());
        request.get("driver-name").set(datasourceVO.getDriverName());
        if (datasourceVO.isUseSecurityDomain()) {
            request.get("security-domain").set(datasourceVO.getSecurityDomain());
        } else {
            request.get("user-name").set(datasourceVO.getUserName());
            request.get("password").set(datasourceVO.getPassword());
        }
        request.get("pool-name").set(datasourceVO.getDatasourceName());
        request.get("transaction-isolation").set(datasourceVO.getTransactionIsolation());
        if (datasourceVO.getMinPoolSize() > 0) {
            request.get("min-pool-size").set(datasourceVO.getMinPoolSize());
        }
        if (datasourceVO.getMaxPoolSize() > 0) {
            request.get("max-pool-size").set(datasourceVO.getMaxPoolSize());
        }
        request.get("jta").set(datasourceVO.isUseJta());
        request.get("use-ccm").set(datasourceVO.isUseCcm());
        request.get("pool-prefill").set(datasourceVO.isPrefill());
        request.get("check-valid-connection-sql").set(datasourceVO.getCheckValidConnectionSql());
        request.get("enabled").set(datasourceVO.isEnabled());
        this.execute(request);
    }

    private void writeSecurityDomainLoginModuleAttribute(SecurityDomainVO securityDomain) throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set("write-attribute");
        request.get("address").add(SUBSYSTEM, "security");
        request.get("address").add("security-domain", securityDomain.getName());
        request.get("address").add("authentication", securityDomain.getAuthentication());
        request.get(NAME).set("login-modules");
        ModelNode list = new ModelNode();
        ModelNode loginModules = new ModelNode();
        loginModules.get("flag").set(securityDomain.getFlag());
        loginModules.get("code").set(securityDomain.getLoginModule());
        ModelNode moduleOptions = loginModules.get("module-options");
        moduleOptions.get("password").set(securityDomain.getPassword());
        moduleOptions.get("username").set(securityDomain.getUsername());
        list.add(loginModules);
        request.get("login-modules").set(list);
        request.get("value").set(list);
        this.execute(request);
    }

    private void writeDsAttribute(String datasourceName, String attributeName, Object attributeValue) throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set("write-attribute");
        request.get("address").add(SUBSYSTEM, "datasources");
        request.get("address").add("data-source", datasourceName);
        request.get(NAME).set(attributeName);
        if (attributeValue instanceof String) {
            request.get("value").set((String)attributeValue);
        } else if (attributeValue instanceof Integer) {
            request.get("value").set((Integer)attributeValue);
        } else if (attributeValue instanceof Boolean) {
            request.get("value").set((Boolean)attributeValue);
        }
        this.execute(request);
    }

    private void undefineDsAttribute(String datasourceName, String attributeName) throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set("undefine-attribute");
        request.get("address").add(SUBSYSTEM, "datasources");
        request.get("address").add("data-source", datasourceName);
        request.get(NAME).set(attributeName);
        this.execute(request);
    }

    public void modifySecurityDomain(SecurityDomainVO newSd, SecurityDomainVO oldSd) throws CliException {
        if (!(oldSd.getLoginModule().equals(newSd.getLoginModule()) && oldSd.getUsername().equals(newSd.getUsername()) && oldSd.getPassword().equals(newSd.getPassword()))) {
            if (newSd.getChangePassword().booleanValue()) {
                newSd.setPassword(JBossCli.encode(newSd.getPassword()));
            }
            this.writeSecurityDomainLoginModuleAttribute(newSd);
        }
        if (this.getServerState().equals("reload-required")) {
            this.reloadConfiguration();
        }
    }

    public void modifyDatasource(DatasourceVO newDS, DatasourceVO oldDS) throws CliException {
        if (!oldDS.getConnectionUrl().equals(newDS.getConnectionUrl())) {
            this.writeDsAttribute(oldDS.getDatasourceName(), "connection-url", newDS.getConnectionUrl());
        }
        if (!oldDS.getTransactionIsolation().equals(newDS.getTransactionIsolation())) {
            this.writeDsAttribute(oldDS.getDatasourceName(), "transaction-isolation", newDS.getTransactionIsolation());
        }
        if (oldDS.isUseJta() != newDS.isUseJta()) {
            this.writeDsAttribute(oldDS.getDatasourceName(), "jta", newDS.isUseJta());
        }
        if (oldDS.isUseCcm() != newDS.isUseCcm()) {
            this.writeDsAttribute(oldDS.getDatasourceName(), "use-ccm", newDS.isUseCcm());
        }
        if (oldDS.isPrefill() != newDS.isPrefill()) {
            this.writeDsAttribute(oldDS.getDatasourceName(), "pool-prefill", newDS.isPrefill());
        }
        if (oldDS.getCheckValidConnectionSql() == null && newDS.getCheckValidConnectionSql() != null || oldDS.getCheckValidConnectionSql() != null && newDS.getCheckValidConnectionSql() != null && !oldDS.getCheckValidConnectionSql().equals(newDS.getCheckValidConnectionSql())) {
            this.writeDsAttribute(oldDS.getDatasourceName(), "check-valid-connection-sql", newDS.getCheckValidConnectionSql());
        }
        if (oldDS.getMinPoolSize() != newDS.getMinPoolSize()) {
            this.writeDsAttribute(oldDS.getDatasourceName(), "min-pool-size", newDS.getMinPoolSize());
        }
        if (oldDS.getMaxPoolSize() != newDS.getMaxPoolSize()) {
            this.writeDsAttribute(oldDS.getDatasourceName(), "max-pool-size", newDS.getMaxPoolSize());
        }
        if (oldDS.isUseSecurityDomain() != newDS.isUseSecurityDomain()) {
            if (newDS.isUseSecurityDomain()) {
                this.undefineDsAttribute(oldDS.getDatasourceName(), "user-name");
                this.undefineDsAttribute(oldDS.getDatasourceName(), "password");
                this.writeDsAttribute(oldDS.getDatasourceName(), "security-domain", newDS.getSecurityDomain());
            } else {
                this.undefineDsAttribute(oldDS.getDatasourceName(), "security-domain");
                this.writeDsAttribute(oldDS.getDatasourceName(), "user-name", newDS.getUserName());
                this.writeDsAttribute(oldDS.getDatasourceName(), "password", newDS.getPassword());
            }
        }
        if (oldDS.isUseSecurityDomain() == newDS.isUseSecurityDomain()) {
            if (newDS.isUseSecurityDomain()) {
                if (!oldDS.getSecurityDomain().equals(newDS.getSecurityDomain())) {
                    this.writeDsAttribute(oldDS.getDatasourceName(), "security-domain", newDS.getSecurityDomain());
                }
            } else {
                if (!oldDS.getUserName().equals(newDS.getUserName())) {
                    this.writeDsAttribute(oldDS.getDatasourceName(), "user-name", newDS.getUserName());
                }
                if (!oldDS.getPassword().equals(newDS.getPassword())) {
                    this.writeDsAttribute(oldDS.getDatasourceName(), "password", newDS.getPassword());
                }
            }
        }
        if (this.getServerState().equals("reload-required")) {
            this.reloadConfiguration();
        }
    }

    public boolean checkIfSecurityDomainExists(String name) throws CliException {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Informe o Nome do Security Domain");
        }
        List<SecurityDomainVO> securityDomains = this.getSecurityDomains();
        for (SecurityDomainVO securityDomainVO : securityDomains) {
            if (!name.equals(securityDomainVO.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean checkIfDatasourceExists(String name) throws CliException {
        ModelNode request = new ModelNode();
        request.get("operation").set(READ_RESOURCE_OPERATION);
        request.get(RECURSIVE).set(false);
        request.get("address").add(SUBSYSTEM, "datasources");
        ModelNode response = this.execute(request);
        ModelNode datasources = response.get("data-source");
        if (datasources.isDefined()) {
            for (ModelNode dataSource : datasources.asList()) {
                String dataSourceName = dataSource.asProperty().getName();
                if (!dataSourceName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public List<JdbcDriverVO> getJDbcDrivers() throws CliException {
        ArrayList<JdbcDriverVO> driverVOList = null;
        ModelNode request = new ModelNode();
        request.get("operation").set("installed-drivers-list");
        request.get("address").add(SUBSYSTEM, "datasources");
        ModelNode response = this.execute(request);
        if (response.isDefined()) {
            driverVOList = new ArrayList<JdbcDriverVO>();
            for (ModelNode driver : response.asList()) {
                JdbcDriverVO driverVO = new JdbcDriverVO();
                driverVO.setDriverName(driver.get("driver-name").isDefined() ? driver.get("driver-name").asString() : null);
                driverVO.setDeploymentName(driver.get("deployment-name").isDefined() ? driver.get("deployment-name").asString() : null);
                driverVO.setModuleName(driver.get("driver-module-name").isDefined() ? driver.get("driver-module-name").asString() : null);
                driverVO.setModuleSlot(driver.get("module-slot").isDefined() ? driver.get("module-slot").asString() : null);
                driverVO.setDatasourceClassName(driver.get("driver-datasource-class-name").isDefined() ? driver.get("driver-datasource-class-name").asString() : null);
                driverVO.setXaDatasourceClassName(driver.get("driver-xa-datasource-class-name").isDefined() ? driver.get("driver-xa-datasource-class-name").asString() : null);
                driverVO.setClassName(driver.get("driver-class-name").isDefined() ? driver.get("driver-class-name").asString() : null);
                driverVO.setMajorVersion(driver.get("driver-major-version").isDefined() ? driver.get("driver-major-version").asInt() : 0);
                driverVO.setMinorVersion(driver.get("driver-minor-version").isDefined() ? driver.get("driver-minor-version").asInt() : 0);
                driverVO.setJdbcCompliant(driver.get("jdbc-compliant").isDefined() ? driver.get("jdbc-compliant").asBoolean() : false);
                driverVOList.add(driverVO);
            }
        }
        return driverVOList;
    }

    public List<SecurityDomainVO> getSecurityDomains() throws CliException {
        ArrayList<SecurityDomainVO> securityDomainVOList;
        block12: {
            securityDomainVOList = null;
            ModelNode request = new ModelNode();
            request.get("operation").set(READ_RESOURCE_OPERATION);
            request.get(RECURSIVE).set(true);
            request.get("address").add(SUBSYSTEM, "security");
            ModelNode response = this.execute(request);
            ModelNode securityDomains = response.get("security-domain");
            if (!securityDomains.isDefined()) break block12;
            securityDomainVOList = new ArrayList<SecurityDomainVO>();
            for (ModelNode security : securityDomains.asList()) {
                SecurityDomainVO securityDomainVO;
                block13: {
                    ModelNode authDataValues;
                    ModelNode loginModule;
                    securityDomainVO = new SecurityDomainVO();
                    securityDomainVO.setName(security.asProperty().getName());
                    ModelNode dataValues = security.asProperty().getValue();
                    securityDomainVO.setCacheType(dataValues.get("cache-type").asString());
                    ModelNode authentication = dataValues.get("authentication");
                    if (!authentication.isDefined() || !(loginModule = (authDataValues = authentication.asProperty().getValue()).get("login-modules")).isDefined()) break block13;
                    ModelNode lModule = loginModule.asList().get(0);
                    securityDomainVO.setLoginModule(lModule.get("code").asString());
                    securityDomainVO.setFlag(lModule.get("flag").asString());
                    ModelNode moduleOptions = lModule.get("module-options");
                    if (!moduleOptions.isDefined()) break block13;
                    for (ModelNode option : moduleOptions.asList()) {
                        if (!option.isDefined()) continue;
                        switch (option.asProperty().getName()) {
                            case "username": {
                                securityDomainVO.setUsername(option.get("username").isDefined() ? option.get("username").asString() : "");
                                break;
                            }
                            case "password": {
                                securityDomainVO.setPassword(option.get("password").isDefined() ? option.get("password").asString() : "");
                            }
                        }
                    }
                }
                securityDomainVOList.add(securityDomainVO);
            }
        }
        return securityDomainVOList;
    }

    public DatasourceVO getDatasource(String datasourceName) throws CliException {
        List<DatasourceVO> datasources = this.getDatasources();
        String lowerDatasourceName = datasourceName.toLowerCase();
        for (DatasourceVO ds : datasources) {
            if (!ds.getDatasourceName().toLowerCase().equals(lowerDatasourceName)) continue;
            return ds;
        }
        return null;
    }

    public List<DatasourceVO> getDatasources() throws CliException {
        ArrayList<DatasourceVO> datasourceVOList = null;
        ModelNode request = new ModelNode();
        request.get("operation").set(READ_RESOURCE_OPERATION);
        request.get(RECURSIVE).set(true);
        request.get("address").add(SUBSYSTEM, "datasources");
        ModelNode response = this.execute(request);
        ModelNode datasources = response.get("data-source");
        if (datasources.isDefined()) {
            datasourceVOList = new ArrayList<DatasourceVO>();
            for (ModelNode dataSource : datasources.asList()) {
                DatasourceVO datasourceVO = new DatasourceVO();
                datasourceVO.setDatasourceName(dataSource.asProperty().getName());
                ModelNode dataValues = dataSource.asProperty().getValue();
                datasourceVO.setConnectionUrl(dataValues.get("connection-url").asString());
                datasourceVO.setDriverClass(dataValues.get("driver-class").asString());
                datasourceVO.setDriverName(dataValues.get("driver-name").asString());
                datasourceVO.setJndiName(dataValues.get("jndi-name").asString());
                datasourceVO.setUserName(dataValues.get("user-name").isDefined() ? dataValues.get("user-name").asString() : null);
                datasourceVO.setPassword(dataValues.get("password").isDefined() ? dataValues.get("password").asString() : null);
                datasourceVO.setSecurityDomain(dataValues.get("security-domain").isDefined() ? dataValues.get("security-domain").asString() : null);
                datasourceVO.setUseSecurityDomain(datasourceVO.getSecurityDomain() != null);
                datasourceVO.setMinPoolSize(dataValues.get("min-pool-size").isDefined() ? dataValues.get("min-pool-size").asInt() : 0);
                datasourceVO.setMaxPoolSize(dataValues.get("max-pool-size").isDefined() ? dataValues.get("max-pool-size").asInt() : 0);
                datasourceVO.setTransactionIsolation(dataValues.get("transaction-isolation").isDefined() ? dataValues.get("transaction-isolation").asString() : null);
                datasourceVO.setUseJta(dataValues.get("jta").asBoolean());
                datasourceVO.setUseCcm(dataValues.get("use-ccm").asBoolean());
                datasourceVO.setPrefill(dataValues.get("pool-prefill").isDefined() ? dataValues.get("pool-prefill").asBoolean() : false);
                datasourceVO.setCheckValidConnectionSql(dataValues.get("check-valid-connection-sql").isDefined() ? dataValues.get("check-valid-connection-sql").asString() : null);
                datasourceVO.setEnabled(dataValues.get("enabled").isDefined() ? dataValues.get("enabled").asBoolean() : false);
                datasourceVOList.add(datasourceVO);
            }
        }
        return datasourceVOList;
    }

    public String checkDeploymentStatus(String deployName) {
        return null;
    }

    public String getServerState(String serverPath) throws CliException {
        ModelNode op = new ModelNode();
        op.get("operation").set(READ_ATTRIBUTE_OPERATION);
        op.get(NAME).set("server-state");
        return this.execute(op).asString();
    }

    public String getServerState() throws CliException {
        ModelNode op = new ModelNode();
        op.get("operation").set(READ_ATTRIBUTE_OPERATION);
        op.get(NAME).set("server-state");
        return this.execute(op).asString();
    }

    public JBossVO getServerInfo() throws CliException {
        ModelNode op = new ModelNode();
        op.get("operation").set(READ_RESOURCE_OPERATION);
        ModelNode result = this.execute(op);
        JBossVO jBossVO = new JBossVO();
        jBossVO.setRunning(true);
        jBossVO.setServerState(this.getServerState());
        jBossVO.setReleaseCodename(result.get("release-codename").asString());
        jBossVO.setReleaseVersion(result.get("release-version").asString());
        return jBossVO;
    }

    public boolean checkIfDeploymentExists(String deploymentName) throws CliException {
        for (String n : this.getDeploymentNames()) {
            if (!n.equals(deploymentName)) continue;
            return true;
        }
        return false;
    }

    private void readRootNode() throws CliException {
        this.rootNode = this.readResource(new ModelNode());
    }

    private ModelNode readResource(ModelNode address) throws CliException {
        ModelNode operation = new ModelNode();
        operation.get("operation").set(READ_RESOURCE_OPERATION);
        operation.get(RECURSIVE).set("true");
        operation.get("address").set(address);
        return this.execute(operation);
    }

    public URI getWebUri() throws CliException {
        if (this.webUri == null) {
            if (this.rootNode == null) {
                this.readRootNode();
            }
            String socketBinding = this.rootNode.get(SUBSYSTEM).get(WEB).get("connector").get("http").get("socket-binding").asString();
            this.webUri = this.getBinding("http", socketBinding);
        }
        return this.webUri;
    }

    private URI getBinding(String protocol, String socketBinding) throws CliException {
        String socketBindingGroupName = this.rootNode.get("socket-binding-group").keys().iterator().next();
        ModelNode operation = new ModelNode();
        operation.get("address").get("socket-binding-group").set(socketBindingGroupName);
        operation.get("address").get("socket-binding").set(socketBinding);
        operation.get("operation").set(READ_ATTRIBUTE_OPERATION);
        operation.get(NAME).set("bound-address");
        String ip = this.execute(operation).asString();
        if (ip.contains(":") && ip.contains("%")) {
            ip = ip.split("%")[0];
        }
        ModelNode portOp = new ModelNode();
        portOp.get("address").get("socket-binding-group").set(socketBindingGroupName);
        portOp.get("address").get("socket-binding").set(socketBinding);
        portOp.get("operation").set(READ_ATTRIBUTE_OPERATION);
        portOp.get(NAME).set("bound-port");
        int port = JBossCli.defined(this.execute(portOp), String.valueOf(socketBindingGroupName) + " -> " + socketBinding + " -> bound-port is undefined").asInt();
        return URI.create(String.valueOf(protocol) + "://" + ip + ":" + port);
    }

    private static ModelNode defined(ModelNode node, String message) {
        if (!node.isDefined()) {
            throw new IllegalStateException(message);
        }
        return node;
    }

    private boolean isEnterpriseArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_EAR);
    }

    private boolean isWebArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_WEB);
    }

    private List<String> extractEnterpriseArchiveContext(ModelNode deploymentNode) {
        ArrayList<String> contexts = new ArrayList<String>();
        if (deploymentNode.hasDefined(SUBDEPLOYMENT)) {
            for (ModelNode subdeployment : deploymentNode.get(SUBDEPLOYMENT).asList()) {
                String deploymentName = subdeployment.keys().iterator().next();
                if (!this.isWebArchive(deploymentName)) continue;
                contexts.addAll(this.extractWebArchiveContext(subdeployment.get(deploymentName)));
            }
        }
        return contexts;
    }

    private List<String> extractWebArchiveContext(ModelNode deploymentNode) {
        ModelNode webSubSystem;
        ModelNode subsystem;
        ArrayList<String> contextsNames = new ArrayList<String>();
        if (deploymentNode.hasDefined(SUBSYSTEM) && (subsystem = deploymentNode.get(SUBSYSTEM)).hasDefined(WEB) && (webSubSystem = subsystem.get(WEB)).isDefined() && webSubSystem.hasDefined("context-root")) {
            contextsNames.add(webSubSystem.get("context-root").asString());
        }
        return contextsNames;
    }

    private ModelNode createDeploymentAddress(String deploymentName) {
        ModelNode address = new ModelNode();
        address.add("deployment", deploymentName);
        return address;
    }

    public MemoriaVO getJvmDetails() throws CliException {
        MemoriaVO memoriaVO = new MemoriaVO();
        HeapVO heapVO = new HeapVO();
        ModelNode request = new ModelNode();
        request.get("operation").set(READ_RESOURCE_OPERATION);
        request.get(RECURSIVE).set(true);
        request.get(INCLUDE_RUNTIME).set(true);
        request.get("address").add("core-service", "platform-mbean");
        request.get("address").add("type", "memory");
        ModelNode response = this.execute(request);
        ModelNode heap = response.get("heap-memory-usage");
        if (heap.isDefined()) {
            heapVO.setInit(heap.get("init").asLong());
            heapVO.setCommitted(heap.get("committed").asLong());
            heapVO.setMax(heap.get("max").asLong());
            heapVO.setUsed(heap.get("used").asLong());
        }
        memoriaVO.setHeapMemoryUsage(heapVO);
        ModelNode nonHeap = response.get("non-heap-memory-usage");
        if (nonHeap.isDefined()) {
            heapVO = new HeapVO();
            heapVO.setInit(nonHeap.get("init").asLong());
            heapVO.setCommitted(nonHeap.get("committed").asLong());
            heapVO.setMax(nonHeap.get("max").asLong());
            heapVO.setUsed(nonHeap.get("used").asLong());
        }
        memoriaVO.setNonHeapMemoryUsage(heapVO);
        return memoriaVO;
    }

    public List<PoolStatisticsVO> getPoolStatistics() throws CliException {
        ArrayList<PoolStatisticsVO> poolStatisticsVOList = null;
        ModelNode request = new ModelNode();
        request.get("operation").set(READ_RESOURCE_OPERATION);
        request.get(RECURSIVE).set(true);
        request.get("address").add(SUBSYSTEM, "datasources");
        ModelNode response = this.execute(request);
        ModelNode datasources = response.get("data-source");
        if (datasources.isDefined()) {
            poolStatisticsVOList = new ArrayList<PoolStatisticsVO>();
            for (ModelNode dataSource : datasources.asList()) {
                PoolStatisticsVO poolStatisticsVO = new PoolStatisticsVO();
                poolStatisticsVO.setDatasourceName(dataSource.asProperty().getName());
                ModelNode op = new ModelNode();
                op.get("operation").set(READ_RESOURCE_OPERATION);
                op.get(INCLUDE_RUNTIME).set(true);
                ModelNode address = op.get("address");
                address.add(SUBSYSTEM, "datasources");
                address.add("data-source", poolStatisticsVO.getDatasourceName());
                address.add("statistics", "pool");
                ModelNode returnVal = this.execute(op);
                poolStatisticsVO.setActiveCount(returnVal.get("ActiveCount").asInt());
                poolStatisticsVO.setAvailableCount(returnVal.get("AvailableCount").asInt());
                poolStatisticsVO.setAverageBlockingTime(returnVal.get("AverageBlockingTime").asLong());
                poolStatisticsVO.setAverageCreationTime(returnVal.get("AverageCreationTime").asLong());
                poolStatisticsVO.setCreatedCount(returnVal.get("CreatedCount").asInt());
                poolStatisticsVO.setDestroyedCount(returnVal.get("DestroyedCount").asInt());
                poolStatisticsVO.setMaxCreationTime(returnVal.get("MaxCreationTime").asLong());
                poolStatisticsVO.setMaxUsedCount(returnVal.get("MaxUsedCount").asInt());
                poolStatisticsVO.setMaxWaitTime(returnVal.get("MaxWaitTime").asLong());
                poolStatisticsVO.setTimedOut(returnVal.get("TimedOut").asInt());
                poolStatisticsVO.setTotalBlockingTime(returnVal.get("TotalBlockingTime").asLong());
                poolStatisticsVO.setTotalCreationTime(returnVal.get("TotalCreationTime").asLong());
                poolStatisticsVOList.add(poolStatisticsVO);
            }
        }
        return poolStatisticsVOList;
    }

    public List<String> getContextsNames(String deploymentName) throws CliException {
        List<String> contexts = null;
        ModelNode deploymentNode = this.readResource(this.createDeploymentAddress(deploymentName));
        if (this.isWebArchive(deploymentName)) {
            contexts = this.extractWebArchiveContext(deploymentNode);
        } else if (this.isEnterpriseArchive(deploymentName)) {
            contexts = this.extractEnterpriseArchiveContext(deploymentNode);
        }
        return contexts;
    }

    private ModelNode execute(ModelNode op) throws CliException {
        return this.execute(OperationBuilder.create(op).build());
    }

    private ModelNode execute(Operation op) throws CliException {
        ModelNode result;
        try {
            result = this.client.execute(op);
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().contains("timed out")) {
                throw new CliException(e.getMessage(), "O Servidor N\u00e3o Respondeu. Verifique o Estado do JBoss, o IP, a Porta e o Firewall.", e);
            }
            throw new CliException(e);
        }
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            return result.get("result");
        }
        if (!result.asString().toLowerCase().contains("duplicate")) {
            logger.error(result);
            throw new CliException(result.get("failure-description").toString());
        }
        return result.get("result");
    }

    public Collection<Throwable> getErrors() {
        if (this.errors == null) {
            this.errors = new ArrayList<Throwable>();
        }
        return this.errors;
    }

    private static String encode(String secret) throws CliException {
        byte[] kbytes = "jaas is the way".getBytes();
        SecretKeySpec key = new SecretKeySpec(kbytes, "Blowfish");
        try {
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(1, key);
            byte[] encoding = cipher.doFinal(secret.getBytes());
            BigInteger n = new BigInteger(encoding);
            return n.toString(16);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CliException(e);
        }
    }

    @Override
    public void close() {
        StreamUtils.safeClose(this.client);
    }
}

