/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.vo;

import java.io.File;
import java.io.Serializable;
import java.util.Date;

public class ArquivoVO
implements Serializable,
Comparable<ArquivoVO> {
    private static final long serialVersionUID = 1L;
    private String nome;
    private Date dataModificacao;
    private long tamanho;
    private final File file;

    public ArquivoVO(File file) {
        this.file = file;
        this.nome = file.getName();
        this.dataModificacao = new Date(file.lastModified());
        this.tamanho = file.length();
    }

    public File getFile() {
        return this.file;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Date getDataModificacao() {
        return this.dataModificacao;
    }

    public void setDataModificacao(Date dataModificacao) {
        this.dataModificacao = dataModificacao;
    }

    public long getTamanho() {
        return this.tamanho;
    }

    public void setTamanho(long tamanho) {
        this.tamanho = tamanho;
    }

    public long getTamanhoEmKB() {
        return Math.round(this.tamanho / 1024L);
    }

    public String getNomeTruncado() {
        if (this.nome.length() > 20) {
            return this.nome.substring(0, 20).concat("...");
        }
        return this.nome;
    }

    @Override
    public int compareTo(ArquivoVO o) {
        return o.getDataModificacao().compareTo(this.getDataModificacao());
    }

    public String toString() {
        return "{nome=" + this.nome + ", dataModificacao=" + this.dataModificacao + ", tamanho=" + this.tamanho + '}';
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArquivoVO other = (ArquivoVO)obj;
        return !(this.nome == null ? other.nome != null : !this.nome.equals(other.nome));
    }
}

