/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.dmr.ModelNode;

public interface ArgumentValueConverter {
    public static final ArgumentValueConverter DEFAULT = new ArgumentValueConverter(){

        @Override
        public ModelNode fromString(String value) throws CommandFormatException {
            if (value == null) {
                return new ModelNode();
            }
            ModelNode toSet = null;
            try {
                toSet = ModelNode.fromString(value);
            }
            catch (Exception e) {
                toSet = new ModelNode().set(value);
            }
            return toSet;
        }
    };
    public static final ArgumentValueConverter LIST = new DMRWithFallbackConverter(){

        @Override
        protected ModelNode fromNonDMRString(String value) throws CommandFormatException {
            if (value.length() >= 2 && value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']') {
                value = value.substring(1, value.length() - 1);
            }
            ModelNode list = new ModelNode();
            for (String item : value.split(",")) {
                list.add(new ModelNode().set(item));
            }
            return list;
        }
    };
    public static final ArgumentValueConverter PROPERTIES = new DMRWithFallbackConverter(){

        @Override
        protected ModelNode fromNonDMRString(String value) throws CommandFormatException {
            if (value.length() >= 2 && value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']') {
                value = value.substring(1, value.length() - 1);
            }
            String[] props = value.split(",");
            ModelNode list = new ModelNode();
            for (String prop : props) {
                int equals = prop.indexOf(61);
                if (equals == -1) {
                    throw new CommandFormatException("Property '" + prop + "' in '" + value + "' is missing the equals sign.");
                }
                String propName = prop.substring(0, equals);
                if (propName.isEmpty()) {
                    throw new CommandFormatException("Property name is missing for '" + prop + "' in '" + value + "'");
                }
                list.add(propName, prop.substring(equals + 1));
            }
            return list;
        }
    };
    public static final ArgumentValueConverter OBJECT = new DMRWithFallbackConverter(){

        @Override
        protected ModelNode fromNonDMRString(String value) throws CommandFormatException {
            if (value.length() >= 2 && value.charAt(0) == '{' && value.charAt(value.length() - 1) == '}') {
                value = value.substring(1, value.length() - 1);
            }
            String[] props = value.split(",");
            ModelNode o = new ModelNode();
            for (String prop : props) {
                int equals = prop.indexOf(61);
                if (equals == -1) {
                    throw new CommandFormatException("Property '" + prop + "' in '" + value + "' is missing the equals sign.");
                }
                String propName = prop.substring(0, equals);
                if (propName.isEmpty()) {
                    throw new CommandFormatException("Property name is missing for '" + prop + "' in '" + value + "'");
                }
                o.get(propName).set(prop.substring(equals + 1));
            }
            return o;
        }
    };

    public ModelNode fromString(String var1) throws CommandFormatException;

    public static abstract class DMRWithFallbackConverter
    implements ArgumentValueConverter {
        @Override
        public ModelNode fromString(String value) throws CommandFormatException {
            if (value == null) {
                return new ModelNode();
            }
            try {
                return ModelNode.fromString(value);
            }
            catch (Exception e) {
                return this.fromNonDMRString(value);
            }
        }

        protected abstract ModelNode fromNonDMRString(String var1) throws CommandFormatException;
    }
}

