/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslException;
import org.jboss.as.cli.CliConfig;
import org.jboss.as.cli.CliEvent;
import org.jboss.as.cli.CliEventListener;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandCompleter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.SSLConfig;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.batch.impl.DefaultBatchManager;
import org.jboss.as.cli.batch.impl.DefaultBatchedCommand;
import org.jboss.as.cli.handlers.ArchiveHandler;
import org.jboss.as.cli.handlers.ClearScreenHandler;
import org.jboss.as.cli.handlers.CommandCommandHandler;
import org.jboss.as.cli.handlers.ConnectHandler;
import org.jboss.as.cli.handlers.DeployHandler;
import org.jboss.as.cli.handlers.DeploymentInfoHandler;
import org.jboss.as.cli.handlers.EchoDMRHandler;
import org.jboss.as.cli.handlers.GenericTypeOperationHandler;
import org.jboss.as.cli.handlers.HelpHandler;
import org.jboss.as.cli.handlers.HistoryHandler;
import org.jboss.as.cli.handlers.LsHandler;
import org.jboss.as.cli.handlers.OperationRequestHandler;
import org.jboss.as.cli.handlers.PrefixHandler;
import org.jboss.as.cli.handlers.PrintWorkingNodeHandler;
import org.jboss.as.cli.handlers.QuitHandler;
import org.jboss.as.cli.handlers.ReadAttributeHandler;
import org.jboss.as.cli.handlers.ReadOperationHandler;
import org.jboss.as.cli.handlers.UndeployHandler;
import org.jboss.as.cli.handlers.VersionHandler;
import org.jboss.as.cli.handlers.batch.BatchClearHandler;
import org.jboss.as.cli.handlers.batch.BatchDiscardHandler;
import org.jboss.as.cli.handlers.batch.BatchEditLineHandler;
import org.jboss.as.cli.handlers.batch.BatchHandler;
import org.jboss.as.cli.handlers.batch.BatchHoldbackHandler;
import org.jboss.as.cli.handlers.batch.BatchListHandler;
import org.jboss.as.cli.handlers.batch.BatchMoveLineHandler;
import org.jboss.as.cli.handlers.batch.BatchRemoveLineHandler;
import org.jboss.as.cli.handlers.batch.BatchRunHandler;
import org.jboss.as.cli.handlers.jca.DataSourceAddHandler;
import org.jboss.as.cli.handlers.jca.DataSourceModifyHandler;
import org.jboss.as.cli.handlers.jca.DataSourceRemoveHandler;
import org.jboss.as.cli.handlers.jca.XADataSourceAddHandler;
import org.jboss.as.cli.handlers.jca.XADataSourceModifyHandler;
import org.jboss.as.cli.handlers.jca.XADataSourceRemoveHandler;
import org.jboss.as.cli.handlers.jms.CreateJmsResourceHandler;
import org.jboss.as.cli.handlers.jms.DeleteJmsResourceHandler;
import org.jboss.as.cli.handlers.jms.JmsCFAddHandler;
import org.jboss.as.cli.handlers.jms.JmsCFRemoveHandler;
import org.jboss.as.cli.handlers.jms.JmsQueueAddHandler;
import org.jboss.as.cli.handlers.jms.JmsQueueRemoveHandler;
import org.jboss.as.cli.handlers.jms.JmsTopicAddHandler;
import org.jboss.as.cli.handlers.jms.JmsTopicRemoveHandler;
import org.jboss.as.cli.impl.CliConfigImpl;
import org.jboss.as.cli.impl.Console;
import org.jboss.as.cli.impl.HeadersArgumentValueConverter;
import org.jboss.as.cli.impl.SecurityActions;
import org.jboss.as.cli.operation.CommandLineParser;
import org.jboss.as.cli.operation.NodePathFormatter;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationCandidatesProvider;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestParser;
import org.jboss.as.cli.operation.impl.DefaultPrefixFormatter;
import org.jboss.as.cli.operation.impl.RolloutPlanCompleter;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.util.HexConverter;

class CommandContextImpl
implements CommandContext {
    private final CliConfig config;
    private final CommandRegistry cmdRegistry = new CommandRegistry();
    private Console console;
    private boolean terminate;
    private String cmdLine;
    private DefaultCallbackHandler parsedCmd = new DefaultCallbackHandler(true);
    private boolean domainMode;
    private ModelControllerClient client;
    private String defaultControllerHost;
    private int defaultControllerPort;
    private String controllerHost;
    private int controllerPort = -1;
    private String username;
    private char[] password;
    private SSLContext sslContext;
    private LazyDelagatingTrustManager trustManager;
    private Map<String, Object> map = new HashMap<String, Object>();
    private final OperationRequestAddress prefix = new DefaultOperationRequestAddress();
    private final NodePathFormatter prefixFormatter = new DefaultPrefixFormatter();
    private final OperationCandidatesProvider operationCandidatesProvider;
    private final OperationRequestHandler operationHandler;
    private BatchManager batchManager = new DefaultBatchManager();
    private final CommandCompleter cmdCompleter;
    private BufferedWriter outputTarget;
    private List<CliEventListener> listeners = new ArrayList<CliEventListener>();
    private int exitCode;
    private File currentDir = new File("");
    private static final String[] FINGERPRINT_ALGORITHMS = new String[]{"MD5", "SHA1"};
    String promptConnectPart;
    private final DefaultCallbackHandler tmpBatched = new DefaultCallbackHandler();

    CommandContextImpl() throws CliInitializationException {
        this.console = null;
        this.operationCandidatesProvider = null;
        this.cmdCompleter = null;
        this.operationHandler = new OperationRequestHandler();
        this.initCommands();
        this.config = CliConfigImpl.load(this);
        this.initSSLContext();
    }

    CommandContextImpl(String username, char[] password) throws CliInitializationException {
        this(null, -1, username, password, false);
    }

    CommandContextImpl(String defaultControllerHost, int defaultControllerPort, String username, char[] password, boolean initConsole) throws CliInitializationException {
        this.config = CliConfigImpl.load(this);
        this.operationHandler = new OperationRequestHandler();
        this.username = username;
        this.password = password;
        this.defaultControllerHost = defaultControllerHost != null ? defaultControllerHost : this.config.getDefaultControllerHost();
        this.defaultControllerPort = defaultControllerPort != -1 ? defaultControllerPort : this.config.getDefaultControllerPort();
        this.initCommands();
        this.initSSLContext();
        if (initConsole) {
            this.cmdCompleter = new CommandCompleter(this.cmdRegistry);
            this.initBasicConsole();
            this.console.addCompleter(this.cmdCompleter);
            this.operationCandidatesProvider = new DefaultOperationCandidatesProvider();
        } else {
            this.cmdCompleter = null;
            this.operationCandidatesProvider = null;
        }
    }

    protected void initBasicConsole() {
        this.console = Console.Factory.getConsole(this);
        this.console.setUseHistory(this.config.isHistoryEnabled());
        this.console.setHistoryFile(new File(this.config.getHistoryFileDir(), this.config.getHistoryFileName()));
        this.console.getHistory().setMaxSize(this.config.getHistoryMaxSize());
    }

    private void initCommands() {
        this.cmdRegistry.registerHandler((CommandHandler)new PrefixHandler(), "cd", "cn");
        this.cmdRegistry.registerHandler((CommandHandler)new ClearScreenHandler(), "clear", "cls");
        this.cmdRegistry.registerHandler((CommandHandler)new CommandCommandHandler(this.cmdRegistry), "command");
        this.cmdRegistry.registerHandler((CommandHandler)new ConnectHandler(), "connect");
        this.cmdRegistry.registerHandler((CommandHandler)new EchoDMRHandler(), "echo-dmr");
        this.cmdRegistry.registerHandler((CommandHandler)new HelpHandler(), "help", "h");
        this.cmdRegistry.registerHandler((CommandHandler)new HistoryHandler(), "history");
        this.cmdRegistry.registerHandler((CommandHandler)new LsHandler(), "ls");
        this.cmdRegistry.registerHandler((CommandHandler)new PrintWorkingNodeHandler(), "pwd", "pwn");
        this.cmdRegistry.registerHandler((CommandHandler)new QuitHandler(), "quit", "q", "exit");
        this.cmdRegistry.registerHandler((CommandHandler)new ReadAttributeHandler(this), "read-attribute");
        this.cmdRegistry.registerHandler((CommandHandler)new ReadOperationHandler(this), "read-operation");
        this.cmdRegistry.registerHandler((CommandHandler)new VersionHandler(), "version");
        this.cmdRegistry.registerHandler((CommandHandler)new DeployHandler(this), "deploy");
        this.cmdRegistry.registerHandler((CommandHandler)new UndeployHandler(this), "undeploy");
        this.cmdRegistry.registerHandler((CommandHandler)new DeploymentInfoHandler(this), "deployment-info");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchHandler(), "batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchDiscardHandler(), "discard-batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchListHandler(), "list-batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchHoldbackHandler(), "holdback-batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchRunHandler(), "run-batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchClearHandler(), "clear-batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchRemoveLineHandler(), "remove-batch-line");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchMoveLineHandler(), "move-batch-line");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchEditLineHandler(), "edit-batch-line");
        this.cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler((CommandContext)this, "/subsystem=datasources/data-source", null), "data-source");
        this.cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler((CommandContext)this, "/subsystem=datasources/xa-data-source", null), "xa-data-source");
        this.cmdRegistry.registerHandler((CommandHandler)new DataSourceAddHandler(this), false, "add-data-source");
        this.cmdRegistry.registerHandler((CommandHandler)new DataSourceModifyHandler(this), false, "modify-data-source");
        this.cmdRegistry.registerHandler((CommandHandler)new DataSourceRemoveHandler(this), false, "remove-data-source");
        this.cmdRegistry.registerHandler((CommandHandler)new XADataSourceAddHandler(this), false, "add-xa-data-source");
        this.cmdRegistry.registerHandler((CommandHandler)new XADataSourceRemoveHandler(this), false, "remove-xa-data-source");
        this.cmdRegistry.registerHandler((CommandHandler)new XADataSourceModifyHandler(this), false, "modify-xa-data-source");
        this.cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler((CommandContext)this, "/subsystem=messaging/hornetq-server=default/jms-queue", "queue-address"), "jms-queue");
        this.cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler((CommandContext)this, "/subsystem=messaging/hornetq-server=default/jms-topic", "topic-address"), "jms-topic");
        this.cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler((CommandContext)this, "/subsystem=messaging/hornetq-server=default/connection-factory", null), "connection-factory");
        this.cmdRegistry.registerHandler((CommandHandler)new JmsQueueAddHandler(this), false, "add-jms-queue");
        this.cmdRegistry.registerHandler((CommandHandler)new JmsQueueRemoveHandler(this), false, "remove-jms-queue");
        this.cmdRegistry.registerHandler((CommandHandler)new JmsTopicAddHandler(this), false, "add-jms-topic");
        this.cmdRegistry.registerHandler((CommandHandler)new JmsTopicRemoveHandler(this), false, "remove-jms-topic");
        this.cmdRegistry.registerHandler((CommandHandler)new JmsCFAddHandler(this), false, "add-jms-cf");
        this.cmdRegistry.registerHandler((CommandHandler)new JmsCFRemoveHandler(this), false, "remove-jms-cf");
        this.cmdRegistry.registerHandler((CommandHandler)new CreateJmsResourceHandler(this), false, "create-jms-resource");
        this.cmdRegistry.registerHandler((CommandHandler)new DeleteJmsResourceHandler(this), false, "delete-jms-resource");
        GenericTypeOperationHandler rolloutPlan = new GenericTypeOperationHandler((CommandContext)this, "/management-client-content=rollout-plans/rollout-plan", null);
        rolloutPlan.addValueConverter("content", new HeadersArgumentValueConverter(this));
        rolloutPlan.addValueCompleter("content", RolloutPlanCompleter.INSTANCE);
        this.cmdRegistry.registerHandler((CommandHandler)rolloutPlan, "rollout-plan");
        this.cmdRegistry.registerHandler((CommandHandler)new ArchiveHandler(this), false, "archive");
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initSSLContext() throws CliInitializationException {
        if (SecurityActions.getSystemProperty("javax.net.ssl.keyStore") != null) return;
        if (SecurityActions.getSystemProperty("javax.net.ssl.trustStore") != null) {
            return;
        }
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        String trustStore = null;
        String trustStorePassword = null;
        boolean modifyTrustStore = true;
        SSLConfig sslConfig = this.config.getSslConfig();
        if (sslConfig != null) {
            String keyStoreLoc = sslConfig.getKeyStore();
            if (keyStoreLoc != null) {
                char[] keyStorePassword = sslConfig.getKeyStorePassword().toCharArray();
                File keyStoreFile = new File(keyStoreLoc);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(keyStoreFile);
                    KeyStore theKeyStore = KeyStore.getInstance("JKS");
                    theKeyStore.load(fis, keyStorePassword);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    keyManagerFactory.init(theKeyStore, keyStorePassword);
                    keyManagers = keyManagerFactory.getKeyManagers();
                }
                catch (IOException e) {
                    try {
                        throw new CliInitializationException(e);
                        catch (GeneralSecurityException e2) {
                            throw new CliInitializationException(e2);
                        }
                    }
                    catch (Throwable throwable) {
                        StreamUtils.safeClose(fis);
                        throw throwable;
                    }
                }
                StreamUtils.safeClose(fis);
            }
            trustStore = sslConfig.getTrustStore();
            trustStorePassword = sslConfig.getTrustStorePassword();
            modifyTrustStore = sslConfig.isModifyTrustStore();
        }
        if (trustStore == null) {
            String userHome = SecurityActions.getSystemProperty("user.home");
            File trustStoreFile = new File(userHome, ".jboss-cli.truststore");
            trustStore = trustStoreFile.getAbsolutePath();
            trustStorePassword = "cli_truststore";
        }
        this.trustManager = new LazyDelagatingTrustManager(trustStore, trustStorePassword, modifyTrustStore);
        trustManagers = new TrustManager[]{this.trustManager};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            this.sslContext = sslContext;
            return;
        }
        catch (GeneralSecurityException e) {
            throw new CliInitializationException(e);
        }
    }

    @Override
    public boolean isTerminated() {
        return this.terminate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String line) throws CommandLineException {
        if (line.isEmpty() || line.charAt(0) == '#') {
            return;
        }
        this.resetArgs(line);
        if (this.parsedCmd.getFormat() == OperationFormat.INSTANCE) {
            ModelNode request = this.parsedCmd.toOperationRequest(this);
            if (this.isBatchMode()) {
                StringBuilder op = new StringBuilder();
                op.append(this.getNodePathFormatter().format(this.parsedCmd.getAddress()));
                op.append(line.substring(line.indexOf(58)));
                DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(op.toString(), request);
                Batch batch = this.getBatchManager().getActiveBatch();
                batch.add(batchedCmd);
                this.printLine("#" + batch.size() + " " + batchedCmd.getCommand());
            } else {
                this.set("OP_REQ", request);
                try {
                    this.operationHandler.handle(this);
                }
                finally {
                    this.set("OP_REQ", null);
                }
            }
        } else {
            String cmdName = this.parsedCmd.getOperationName();
            CommandHandler handler = this.cmdRegistry.getCommandHandler(cmdName.toLowerCase());
            if (handler != null) {
                if (this.isBatchMode() && handler.isBatchMode(this)) {
                    if (!(handler instanceof OperationCommand)) {
                        throw new CommandLineException("The command is not allowed in a batch.");
                    }
                    try {
                        ModelNode request = ((OperationCommand)handler).buildRequest(this);
                        DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(line, request);
                        Batch batch = this.getBatchManager().getActiveBatch();
                        batch.add(batchedCmd);
                        this.printLine("#" + batch.size() + " " + batchedCmd.getCommand());
                    }
                    catch (CommandFormatException e) {
                        throw new CommandFormatException("Failed to add to batch '" + line + "'", e);
                    }
                } else {
                    handler.handle(this);
                }
            } else {
                throw new CommandLineException("Unexpected command '" + line + "'. Type 'help --commands' for the list of supported commands.");
            }
        }
    }

    @Override
    public void handleSafe(String line) {
        this.exitCode = 0;
        try {
            this.handle(line);
        }
        catch (CommandLineException e) {
            this.error(e.getLocalizedMessage());
        }
    }

    @Override
    public String getArgumentsString() {
        if (this.cmdLine != null && this.parsedCmd.getOperationName() != null) {
            int cmdNameLength = this.parsedCmd.getOperationName().length();
            if (this.cmdLine.length() == cmdNameLength) {
                return null;
            }
            return this.cmdLine.substring(cmdNameLength + 1);
        }
        return null;
    }

    @Override
    public void terminateSession() {
        this.terminate = true;
        this.disconnectController();
    }

    @Override
    public void printLine(String message) {
        if (this.outputTarget != null) {
            try {
                this.outputTarget.append(message);
                this.outputTarget.newLine();
                this.outputTarget.flush();
            }
            catch (IOException e) {
                System.err.println("Failed to print '" + message + "' to the output target: " + e.getLocalizedMessage());
            }
            return;
        }
        if (this.console != null) {
            this.console.print(message);
            this.console.printNewLine();
        } else {
            System.out.println(message);
        }
    }

    protected void error(String message) {
        this.exitCode = 1;
        this.printLine(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine(String prompt, boolean password, boolean disableHistory) throws IOException {
        boolean useHistory;
        if (this.console == null) {
            this.initBasicConsole();
        }
        if ((useHistory = this.console.isUseHistory()) && disableHistory) {
            this.console.setUseHistory(false);
        }
        try {
            if (password) {
                String string = this.console.readLine(prompt, Character.valueOf('\u0000'));
                return string;
            }
            String string = this.console.readLine(prompt);
            return string;
        }
        finally {
            if (disableHistory && useHistory) {
                this.console.setUseHistory(true);
            }
        }
    }

    @Override
    public void printColumns(Collection<String> col) {
        if (this.outputTarget != null) {
            try {
                for (String item : col) {
                    this.outputTarget.append(item);
                    this.outputTarget.newLine();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to print columns '" + col + "' to the console: " + e.getLocalizedMessage());
            }
            return;
        }
        if (this.console != null) {
            this.console.printColumns(col);
        } else {
            for (String item : col) {
                System.out.println(item);
            }
        }
    }

    @Override
    public void set(String key, Object value) {
        this.map.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public ModelControllerClient getModelControllerClient() {
        return this.client;
    }

    @Override
    public CommandLineParser getCommandLineParser() {
        return DefaultOperationRequestParser.INSTANCE;
    }

    @Override
    public OperationRequestAddress getCurrentNodePath() {
        return this.prefix;
    }

    @Override
    public NodePathFormatter getNodePathFormatter() {
        return this.prefixFormatter;
    }

    @Override
    public OperationCandidatesProvider getOperationCandidatesProvider() {
        return this.operationCandidatesProvider;
    }

    @Override
    public void connectController() throws CommandLineException {
        this.connectController(null, -1);
    }

    @Override
    public void connectController(String host, int port) throws CommandLineException {
        boolean retry;
        if (host == null) {
            host = this.defaultControllerHost;
        }
        if (port < 0) {
            port = this.defaultControllerPort;
        }
        do {
            retry = false;
            try {
                ModelControllerClient newClient = null;
                AuthenticationCallbackHandler cbh = new AuthenticationCallbackHandler(this.username, this.password);
                ModelControllerClient tempClient = ModelControllerClient.Factory.create(host, port, (CallbackHandler)cbh, this.sslContext);
                switch (this.initialConnection(tempClient)) {
                    case SUCCESS: {
                        newClient = tempClient;
                        break;
                    }
                    case CONNECTION_FAILURE: {
                        throw new CommandLineException("The controller is not available at " + host + ":" + port);
                    }
                    case AUTHENTICATION_FAILURE: {
                        throw new CommandLineException("Unable to authenticate against controller at " + host + ":" + port);
                    }
                    case SSL_FAILURE: {
                        try {
                            retry = this.handleSSLFailure();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        if (retry) break;
                        throw new CommandLineException("Unable to negotiate SSL connection with controller at " + host + ":" + port);
                    }
                }
                if (newClient == null) continue;
                if (this.client != null) {
                    this.disconnectController();
                }
                this.client = newClient;
                this.controllerHost = host;
                this.controllerPort = port;
                List<String> nodeTypes = Util.getNodeTypes(newClient, new DefaultOperationRequestAddress());
                this.domainMode = nodeTypes.contains("server-group");
            }
            catch (UnknownHostException e) {
                throw new CommandLineException("Failed to resolve host '" + host + "': " + e.getLocalizedMessage());
            }
        } while (retry);
    }

    @Override
    public File getCurrentDir() {
        return this.currentDir;
    }

    @Override
    public void setCurrentDir(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("dir is null");
        }
        this.currentDir = dir;
    }

    private boolean handleSSLFailure() throws IOException {
        Certificate[] lastChain;
        if (this.trustManager == null || (lastChain = this.trustManager.getLastFailedCertificateChain()) == null) {
            return false;
        }
        this.error("Unable to connect due to unrecognised server certificate");
        for (Certificate current : lastChain) {
            if (!(current instanceof X509Certificate)) continue;
            X509Certificate x509Current = (X509Certificate)current;
            Map<String, String> fingerprints = this.generateFingerprints(x509Current);
            this.printLine("Subject    - " + x509Current.getSubjectX500Principal().getName());
            this.printLine("Issuer     - " + x509Current.getIssuerDN().getName());
            this.printLine("Valid From - " + x509Current.getNotBefore());
            this.printLine("Valid To   - " + x509Current.getNotAfter());
            for (String alg : fingerprints.keySet()) {
                this.printLine(alg + " : " + fingerprints.get(alg));
            }
            this.printLine("");
        }
        while (true) {
            String response;
            if ((response = this.trustManager.isModifyTrustStore() ? this.readLine("Accept certificate? [N]o, [T]emporarily, [P]ermenantly : ", false, true) : this.readLine("Accept certificate? [N]o, [T]emporarily : ", false, true)) == null || response.length() != 1) {
                continue;
            }
            switch (response.toLowerCase().charAt(0)) {
                case 'n': {
                    return false;
                }
                case 't': {
                    this.trustManager.storeChainTemporarily(lastChain);
                    return true;
                }
                case 'p': {
                    if (!this.trustManager.isModifyTrustStore()) break;
                    this.trustManager.storeChainPermenantly(lastChain);
                    return true;
                }
            }
        }
    }

    private Map<String, String> generateFingerprints(X509Certificate cert) throws IOException {
        HashMap<String, String> fingerprints = new HashMap<String, String>(FINGERPRINT_ALGORITHMS.length);
        for (String current : FINGERPRINT_ALGORITHMS) {
            try {
                fingerprints.put(current, this.generateFingerPrint(current, cert.getEncoded()));
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Unable to generate fingerprint", e);
            }
        }
        return fingerprints;
    }

    private String generateFingerPrint(String algorithm, byte[] cert) throws GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] digested = md.digest(cert);
        String hex = HexConverter.convertToHexString(digested);
        boolean started = false;
        for (int i = 0; i < hex.length() - 1; i += 2) {
            if (started) {
                sb.append(":");
            } else {
                started = true;
            }
            sb.append(hex.substring(i, i + 2));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectStatus initialConnection(ModelControllerClient client) {
        try {
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("read-attribute");
            builder.addProperty("name", "name");
            client.execute(builder.buildRequest());
            return ConnectStatus.SUCCESS;
        }
        catch (Exception e) {
            try {
                for (Throwable current = e; current != null; current = current.getCause()) {
                    if (current instanceof SaslException) {
                        ConnectStatus connectStatus = ConnectStatus.AUTHENTICATION_FAILURE;
                        return connectStatus;
                    }
                    if (!(current instanceof SSLException)) continue;
                    ConnectStatus connectStatus = ConnectStatus.SSL_FAILURE;
                    return connectStatus;
                }
                ConnectStatus connectStatus = ConnectStatus.CONNECTION_FAILURE;
                return connectStatus;
            }
            finally {
                StreamUtils.safeClose(client);
            }
        }
    }

    @Override
    public void disconnectController() {
        if (this.client != null) {
            StreamUtils.safeClose(this.client);
            this.client = null;
            this.controllerHost = null;
            this.controllerPort = -1;
            this.domainMode = false;
            this.notifyListeners(CliEvent.DISCONNECTED);
        }
        this.promptConnectPart = null;
    }

    @Override
    public String getControllerHost() {
        return this.controllerHost;
    }

    @Override
    public int getControllerPort() {
        return this.controllerPort;
    }

    @Override
    public void clearScreen() {
        this.console.clearScreen();
    }

    String getPrompt() {
        StringBuilder buffer = new StringBuilder();
        if (this.promptConnectPart == null) {
            buffer.append('[');
            if (this.controllerHost != null) {
                if (this.domainMode) {
                    buffer.append("domain@");
                } else {
                    buffer.append("standalone@");
                }
                buffer.append(this.controllerHost).append(':').append(this.controllerPort).append(' ');
                this.promptConnectPart = buffer.toString();
            } else {
                buffer.append("disconnected ");
            }
        } else {
            buffer.append(this.promptConnectPart);
        }
        if (this.prefix.isEmpty()) {
            buffer.append('/');
        } else {
            buffer.append(this.prefix.getNodeType());
            String nodeName = this.prefix.getNodeName();
            if (nodeName != null) {
                buffer.append('=').append(nodeName);
            }
        }
        if (this.isBatchMode()) {
            buffer.append(" #");
        }
        buffer.append("] ");
        return buffer.toString();
    }

    @Override
    public CommandHistory getHistory() {
        return this.console.getHistory();
    }

    @Override
    public String getDefaultControllerHost() {
        return this.defaultControllerHost;
    }

    @Override
    public int getDefaultControllerPort() {
        return this.defaultControllerPort;
    }

    private void resetArgs(String cmdLine) throws CommandFormatException {
        if (cmdLine != null) {
            this.parsedCmd.parse(this.prefix, cmdLine);
            this.setOutputTarget(this.parsedCmd.getOutputTarget());
        }
        this.cmdLine = cmdLine;
    }

    @Override
    public boolean isBatchMode() {
        return this.batchManager.isBatchActive();
    }

    @Override
    public BatchManager getBatchManager() {
        return this.batchManager;
    }

    @Override
    public BatchedCommand toBatchedCommand(String line) throws CommandFormatException {
        return new DefaultBatchedCommand(line, this.buildRequest(line, true));
    }

    @Override
    public ModelNode buildRequest(String line) throws CommandFormatException {
        return this.buildRequest(line, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelNode buildRequest(String line, boolean batchMode) throws CommandFormatException {
        if (line == null || line.isEmpty()) {
            throw new OperationFormatException("The line is null or empty.");
        }
        DefaultCallbackHandler originalParsedArguments = this.parsedCmd;
        try {
            this.parsedCmd = this.tmpBatched;
            this.resetArgs(line);
        }
        catch (CommandFormatException e) {
            this.parsedCmd = originalParsedArguments;
            throw e;
        }
        if (this.parsedCmd.getFormat() == OperationFormat.INSTANCE) {
            try {
                ModelNode request = this.parsedCmd.toOperationRequest(this);
                StringBuilder op = new StringBuilder();
                op.append(this.prefixFormatter.format(this.parsedCmd.getAddress()));
                op.append(line.substring(line.indexOf(58)));
                ModelNode modelNode = request;
                return modelNode;
            }
            finally {
                this.parsedCmd = originalParsedArguments;
            }
        }
        CommandHandler handler = this.cmdRegistry.getCommandHandler(this.parsedCmd.getOperationName());
        if (handler == null) {
            throw new OperationFormatException("No command handler for '" + this.parsedCmd.getOperationName() + "'.");
        }
        if (batchMode) {
            if (!handler.isBatchMode(this)) {
                throw new OperationFormatException("The command is not allowed in a batch.");
            }
        } else if (!(handler instanceof OperationCommand)) {
            throw new OperationFormatException("The command does not translate to an operation request.");
        }
        try {
            ModelNode modelNode = ((OperationCommand)handler).buildRequest(this);
            return modelNode;
        }
        finally {
            this.parsedCmd = originalParsedArguments;
        }
    }

    @Override
    public CommandLineCompleter getDefaultCommandCompleter() {
        return this.cmdCompleter;
    }

    @Override
    public ParsedCommandLine getParsedCommandLine() {
        return this.parsedCmd;
    }

    @Override
    public boolean isDomainMode() {
        return this.domainMode;
    }

    @Override
    public void addEventListener(CliEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null.");
        }
        this.listeners.add(listener);
    }

    @Override
    public CliConfig getConfig() {
        return this.config;
    }

    protected void setOutputTarget(String filePath) {
        FileWriter writer;
        if (filePath == null) {
            this.outputTarget = null;
            return;
        }
        try {
            writer = new FileWriter(filePath, false);
        }
        catch (IOException e) {
            this.error(e.getLocalizedMessage());
            return;
        }
        this.outputTarget = new BufferedWriter(writer);
    }

    protected void notifyListeners(CliEvent event) {
        for (CliEventListener listener : this.listeners) {
            listener.cliEvent(event, this);
        }
    }

    @Override
    public void interact() {
        if (this.cmdCompleter == null) {
            throw new IllegalStateException("The console hasn't been initialized at construction time.");
        }
        if (this.client == null) {
            this.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
        }
        try {
            while (!this.isTerminated()) {
                String line = this.console.readLine(this.getPrompt());
                if (line == null) {
                    this.terminateSession();
                    continue;
                }
                this.handleSafe(line.trim());
            }
            this.printLine("");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private class LazyDelagatingTrustManager
    implements X509TrustManager {
        private final String trustStore;
        private final String trustStorePassword;
        private final boolean modifyTrustStore;
        private Set<X509Certificate> temporarilyTrusted = new HashSet<X509Certificate>();
        private Certificate[] lastFailedCert;
        private X509TrustManager delegate;

        LazyDelagatingTrustManager(String trustStore, String trustStorePassword, boolean modifyTrustStore) {
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
            this.modifyTrustStore = modifyTrustStore;
        }

        boolean isModifyTrustStore() {
            return this.modifyTrustStore;
        }

        void setFailedCertChain(Certificate[] chain) {
            this.lastFailedCert = chain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Certificate[] getLastFailedCertificateChain() {
            try {
                Certificate[] certificateArray = this.lastFailedCert;
                return certificateArray;
            }
            finally {
                this.lastFailedCert = null;
            }
        }

        synchronized void storeChainTemporarily(Certificate[] chain) {
            for (Certificate current : chain) {
                if (!(current instanceof X509Certificate)) continue;
                this.temporarilyTrusted.add((X509Certificate)current);
            }
            this.delegate = null;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        synchronized void storeChainPermenantly(Certificate[] chain) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                KeyStore theTrustStore = KeyStore.getInstance("JKS");
                File trustStoreFile = new File(this.trustStore);
                if (trustStoreFile.exists()) {
                    fis = new FileInputStream(trustStoreFile);
                    theTrustStore.load(fis, this.trustStorePassword.toCharArray());
                    StreamUtils.safeClose(fis);
                    fis = null;
                } else {
                    theTrustStore.load(null);
                }
                for (Certificate current : chain) {
                    if (!(current instanceof X509Certificate)) continue;
                    X509Certificate x509Current = (X509Certificate)current;
                    theTrustStore.setCertificateEntry(x509Current.getSubjectX500Principal().getName(), x509Current);
                }
                fos = new FileOutputStream(trustStoreFile);
                theTrustStore.store(fos, this.trustStorePassword.toCharArray());
            }
            catch (GeneralSecurityException e) {
                try {
                    throw new IllegalStateException("Unable to operate on trust store.", e);
                    catch (IOException e2) {
                        throw new IllegalStateException("Unable to operate on trust store.", e2);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(fis);
                    StreamUtils.safeClose(fos);
                    throw throwable;
                }
            }
            StreamUtils.safeClose(fis);
            StreamUtils.safeClose(fos);
            this.delegate = null;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private synchronized X509TrustManager getDelegate() {
            if (this.delegate == null) {
                FileInputStream fis = null;
                try {
                    TrustManager[] trustManagers;
                    KeyStore theTrustStore = KeyStore.getInstance("JKS");
                    File trustStoreFile = new File(this.trustStore);
                    if (trustStoreFile.exists()) {
                        fis = new FileInputStream(trustStoreFile);
                        theTrustStore.load(fis, this.trustStorePassword.toCharArray());
                    } else {
                        theTrustStore.load(null);
                    }
                    for (X509Certificate current : this.temporarilyTrusted) {
                        theTrustStore.setCertificateEntry(current.getSubjectX500Principal().getName(), current);
                    }
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                    trustManagerFactory.init(theTrustStore);
                    for (TrustManager current : trustManagers = trustManagerFactory.getTrustManagers()) {
                        if (!(current instanceof X509TrustManager)) continue;
                        this.delegate = (X509TrustManager)current;
                        break;
                    }
                }
                catch (GeneralSecurityException e) {
                    try {
                        throw new IllegalStateException("Unable to operate on trust store.", e);
                        catch (IOException e2) {
                            throw new IllegalStateException("Unable to operate on trust store.", e2);
                        }
                    }
                    catch (Throwable throwable) {
                        StreamUtils.safeClose(fis);
                        throw throwable;
                    }
                }
                StreamUtils.safeClose(fis);
            }
            if (this.delegate == null) {
                throw new IllegalStateException("Unable to create delegate trust manager.");
            }
            return this.delegate;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.getDelegate().checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.getDelegate().checkServerTrusted(chain, authType);
            }
            catch (CertificateException ce) {
                this.setFailedCertChain(chain);
                throw ce;
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.getDelegate().getAcceptedIssuers();
        }
    }

    private class AuthenticationCallbackHandler
    implements CallbackHandler {
        private String realm = null;
        private boolean realmShown = false;
        private String username;
        private char[] password;
        private String digest;

        private AuthenticationCallbackHandler(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        private AuthenticationCallbackHandler(String username, String digest) {
            this.username = username;
            this.digest = digest;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
                ((NameCallback)callbacks[0]).setName("anonymous CLI user");
                return;
            }
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    String defaultText;
                    RealmCallback rcb = (RealmCallback)current;
                    this.realm = defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    if (this.username == null) {
                        this.showRealm();
                        this.username = CommandContextImpl.this.readLine("Username: ", false, true);
                        if (this.username == null || this.username.length() == 0) {
                            throw new SaslException("No username supplied.");
                        }
                    }
                    ncb.setName(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback && this.digest == null) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    if (this.password == null) {
                        this.showRealm();
                        String temp = CommandContextImpl.this.readLine("Password: ", true, false);
                        if (temp != null) {
                            this.password = temp.toCharArray();
                        }
                    }
                    pcb.setPassword(this.password);
                    continue;
                }
                if (current instanceof DigestHashCallback && this.digest != null) {
                    DigestHashCallback dhc = (DigestHashCallback)current;
                    dhc.setHexHash(this.digest);
                    continue;
                }
                CommandContextImpl.this.error("Unexpected Callback " + current.getClass().getName());
                throw new UnsupportedCallbackException(current);
            }
        }

        private void showRealm() {
            if (!this.realmShown && this.realm != null) {
                this.realmShown = true;
                CommandContextImpl.this.printLine("Authenticating against security realm: " + this.realm);
            }
        }
    }

    private static enum ConnectStatus {
        SUCCESS,
        AUTHENTICATION_FAILURE,
        SSL_FAILURE,
        CONNECTION_FAILURE;

    }
}

