/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.net.ConnectException;
import java.net.URI;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;

@MessageBundle(projectCode="JBAS")
public interface ProtocolMessages {
    public static final ProtocolMessages MESSAGES = Messages.getBundle(ProtocolMessages.class);

    @Message(id=12140, value="Already connected")
    public IllegalStateException alreadyConnected();

    @Message(id=12141, value="Channel and receiver already started")
    public IllegalStateException alreadyStarted();

    @Message(id=12142, value="Can't use both a connect timeout and a connect timeout property")
    public IllegalArgumentException cannotSpecifyMultipleTimeouts();

    @Message(id=12143, value="Can't set uriScheme with specified endpoint")
    public IllegalArgumentException cannotSetUriScheme();

    @Message(id=12144, value="Could not connect to %s. The connection timed out")
    public ConnectException couldNotConnect(URI var1);

    @Message(id=12145, value="Connection was cancelled")
    public ConnectException connectWasCancelled();

    @Message(id=12146, value="Failed to create server thread")
    public IOException failedToCreateServerThread();

    @Message(id=12147, value="Failed to read object")
    public IOException failedToReadObject(@Cause Throwable var1);

    @Message(id=12148, value="Failed to write management response headers")
    public IOException failedToWriteManagementResponseHeaders(@Cause Throwable var1);

    @Message(id=12149, value="Invalid byte")
    public UTFDataFormatException invalidByte();

    @Message(id=12150, value="Invalid byte:%s(%d)")
    public UTFDataFormatException invalidByte(char var1, int var2);

    @Message(id=12151, value="Invalid byte token.  Expecting '%d' received '%d'")
    public IOException invalidByteToken(int var1, byte var2);

    @Message(id=12152, value="Invalid command byte read: %s")
    public IOException invalidCommandByte(int var1);

    @Message(id=12153, value="Invalid signature [%s]")
    public IOException invalidSignature(String var1);

    @Message(id=12154, value="Invalid start chunk start [%s]")
    public IOException invalidStartChunk(int var1);

    @Message(id=12155, value="Invalid type: %s")
    public IOException invalidType(String var1);

    @Message(id=12156, value="Type is neither %s or %s: %s")
    public IllegalArgumentException invalidType(String var1, String var2, byte var3);

    @Message(id=12157, value="Only '%s' is a valid url")
    public IllegalArgumentException invalidUrl(String var1);

    @Message(id=12158, value="No operation handler set")
    public IOException operationHandlerNotSet();

    @Message(id=12159, value="Not connected")
    public IllegalStateException notConnected();

    @Message(id=12160, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=12161, value="%s and %s are null")
    public IllegalArgumentException nullParameters(String var1, String var2);

    @Message(id=12162, value="Read %d bytes.")
    public EOFException readBytes(int var1);

    @Message(id=12163, value="No request handler found with id %s in operation handler %s")
    public IOException requestHandlerIdNotFound(byte var1, AbstractMessageHandler var2);

    @Message(id=12164, value="Response handler already registered for request")
    public IOException responseHandlerAlreadyRegistered();

    @Message(value="No response handler for request %s")
    public IOException responseHandlerNotFound(int var1);

    @Message(id=12165, value="A problem happened executing on the server: %s")
    public IOException serverError(String var1);

    @Message(id=12166, value="Stream closed")
    public IOException streamClosed();

    @Message(id=12167, value="Thread creation was refused")
    public IllegalStateException threadCreationRefused();

    @Message(id=12168, value="Unexpected end of stream")
    public EOFException unexpectedEndOfStream();

    @Message(id=12169, value="Scheme %s does not match uri %s")
    public IllegalArgumentException unmatchedScheme(String var1, URI var2);

    @Message(id=12170, value="Write channel closed")
    public IOException writeChannelClosed();

    @Message(id=12171, value="Writes are already shut down")
    public IOException writesAlreadyShutdown();

    @Message(id=12172, value="Operation with id %d already registered")
    public IllegalStateException operationIdAlreadyExists(int var1);

    @Message(id=12173, value="Null executor")
    public IllegalArgumentException nullExecutor();

    @Message(id=12174, value="Could not connect to %s. The connection failed")
    public ConnectException failedToConnect(URI var1, @Cause IOException var2);

    @Message(id=12175, value="Channel closed")
    public IOException channelClosed();
}

